/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.gcapi3.impl.screen.widget;

import lombok.Generated;
import net.minecraft.class_33;
import net.minecraft.class_67;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class GlassEntryListWidget {
    protected final Minecraft minecraft;
    protected final int width;
    protected final int height;
    protected final int top;
    protected final int bottom;
    protected final int right;
    protected final int left;
    protected final int itemHeight;
    protected int scrollUpButtonId;
    protected int scrollDownButtonId;
    protected float scrollMode = -2.0f;
    protected float scrollDirection;
    protected float scrollAmount;
    protected int lastHoveredEntry = -1;
    protected long lastClicked = 0L;
    protected boolean drawSelectedBox = true;
    protected int firstEntryRenderOffset;
    protected final int margin;

    public GlassEntryListWidget(Minecraft minecraft, int width, int height, int top, int bottom, int itemHeight) {
        this.minecraft = minecraft;
        this.width = width;
        this.height = height;
        this.top = top;
        this.bottom = bottom;
        this.itemHeight = itemHeight;
        this.left = 0;
        this.right = width;
        this.margin = 20;
    }

    protected abstract int getEntryCount();

    protected abstract void entryClicked(int var1, boolean var2);

    protected abstract boolean isSelectedEntry(int var1);

    protected int getEntriesHeight() {
        return this.getEntryCount() * this.itemHeight + this.firstEntryRenderOffset;
    }

    protected abstract void renderBackground();

    protected abstract void renderEntry(int var1, int var2, int var3, int var4, int var5, class_67 var6);

    public int getHoveredEntry(int mouseX, int mouseY) {
        int endX = this.getWidgetRight();
        int startX = this.getWidgetLeft();
        int relativeMouseY = mouseY - this.top - this.firstEntryRenderOffset + (int)this.scrollAmount - 4;
        int hoveredEntry = relativeMouseY / this.itemHeight;
        return mouseX >= endX && mouseX <= startX && hoveredEntry >= 0 && relativeMouseY >= 0 && hoveredEntry < this.getEntryCount() ? hoveredEntry : -1;
    }

    public int getWidgetLeft() {
        return this.margin;
    }

    public int getWidgetRight() {
        return this.width - this.margin;
    }

    public void setScrollButtons(int scrollUp, int scrollDown) {
        this.scrollUpButtonId = scrollUp;
        this.scrollDownButtonId = scrollDown;
    }

    public void scroll(float amount) {
        this.scrollAmount += amount;
    }

    protected void processScroll() {
        int maxScroll = this.getEntriesHeight() - (this.bottom - this.top - 4);
        if (maxScroll < 0) {
            maxScroll /= 2;
        }
        if (this.scrollAmount < 0.0f) {
            this.scrollAmount = 0.0f;
        }
        if (this.scrollAmount > (float)maxScroll) {
            this.scrollAmount = maxScroll;
        }
    }

    public void buttonClicked(class_33 button) {
        if (button.field_1374) {
            if (button.field_1373 == this.scrollUpButtonId) {
                this.scrollAmount -= (float)(this.itemHeight * 2 / 3);
                this.scrollMode = -2.0f;
                this.processScroll();
            } else if (button.field_1373 == this.scrollDownButtonId) {
                this.scrollAmount += (float)(this.itemHeight * 2 / 3);
                this.scrollMode = -2.0f;
                this.processScroll();
            }
        }
    }

    public void render(int mouseX, int mouseY, float f) {
        int var13;
        int var19;
        int hoveredEntry;
        int relativeMousePosition;
        int scrollAreaStartX;
        this.renderBackground();
        int entryCount = this.getEntryCount();
        int scrollbarStart = this.width - 6;
        int scrollbarEnd = scrollbarStart + 6;
        if (Mouse.isButtonDown((int)0)) {
            if (this.scrollMode == -1.0f) {
                boolean shouldScroll = true;
                if (mouseY >= this.top && mouseY <= this.bottom) {
                    int scrollAreaEndX = this.getWidgetLeft();
                    scrollAreaStartX = this.getWidgetRight();
                    relativeMousePosition = mouseY - this.top - this.firstEntryRenderOffset + (int)this.scrollAmount - 4;
                    hoveredEntry = relativeMousePosition / this.itemHeight;
                    if (mouseX >= scrollAreaEndX && mouseX <= scrollAreaStartX && hoveredEntry >= 0 && relativeMousePosition >= 0 && hoveredEntry < entryCount) {
                        boolean doubleClicked = hoveredEntry == this.lastHoveredEntry && System.currentTimeMillis() - this.lastClicked < 250L;
                        this.entryClicked(hoveredEntry, doubleClicked);
                        this.lastHoveredEntry = hoveredEntry;
                        this.lastClicked = doubleClicked ? 0L : System.currentTimeMillis();
                    } else if (mouseX >= scrollAreaEndX && mouseX <= scrollAreaStartX && relativeMousePosition < 0) {
                        shouldScroll = false;
                    }
                    if (mouseX >= scrollbarStart && mouseX <= scrollbarEnd) {
                        this.scrollDirection = -1.0f;
                        var19 = this.getEntriesHeight() - (this.bottom - this.top - 4);
                        if (var19 < 1) {
                            var19 = 1;
                        }
                        if ((var13 = (int)((float)((this.bottom - this.top) * (this.bottom - this.top)) / (float)this.getEntriesHeight())) < 32) {
                            var13 = 32;
                        }
                        if (var13 > this.bottom - this.top - 8) {
                            var13 = this.bottom - this.top - 8;
                        }
                        this.scrollDirection /= (float)(this.bottom - this.top - var13) / (float)var19;
                    } else {
                        this.scrollDirection = 1.0f;
                    }
                    this.scrollMode = shouldScroll ? (float)mouseY : -2.0f;
                } else {
                    this.scrollMode = -2.0f;
                }
            } else if (this.scrollMode >= 0.0f) {
                this.scrollAmount -= ((float)mouseY - this.scrollMode) * this.scrollDirection;
                this.scrollMode = mouseY;
            }
        } else {
            this.scrollMode = -1.0f;
        }
        this.processScroll();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        class_67 var16 = class_67.field_2054;
        GL11.glBindTexture((int)3553, (int)this.minecraft.field_2814.method_1100("/gui/background.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float var17 = 32.0f;
        var16.method_1695();
        var16.method_1698(0x202020);
        var16.method_1688((double)this.left, (double)this.bottom, 0.0, (double)((float)this.left / var17), (double)((float)(this.bottom + (int)this.scrollAmount) / var17));
        var16.method_1688((double)this.right, (double)this.bottom, 0.0, (double)((float)this.right / var17), (double)((float)(this.bottom + (int)this.scrollAmount) / var17));
        var16.method_1688((double)this.right, (double)this.top, 0.0, (double)((float)this.right / var17), (double)((float)(this.top + (int)this.scrollAmount) / var17));
        var16.method_1688((double)this.left, (double)this.top, 0.0, (double)((float)this.left / var17), (double)((float)(this.top + (int)this.scrollAmount) / var17));
        var16.method_1685();
        scrollAreaStartX = this.getWidgetLeft() + 4;
        relativeMousePosition = this.top + 4 - (int)this.scrollAmount;
        for (hoveredEntry = 0; hoveredEntry < entryCount; ++hoveredEntry) {
            var19 = relativeMousePosition + hoveredEntry * this.itemHeight + this.firstEntryRenderOffset;
            var13 = this.itemHeight - 4;
            if (var19 > this.bottom || var19 + var13 < this.top) continue;
            if (this.drawSelectedBox && this.isSelectedEntry(hoveredEntry)) {
                int entryEndX = this.getWidgetRight();
                int entryStartX = this.getWidgetLeft();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)3553);
                var16.method_1695();
                var16.method_1698(0x808080);
                var16.method_1688((double)entryEndX, (double)(var19 + var13 + 2), 0.0, 0.0, 1.0);
                var16.method_1688((double)entryStartX, (double)(var19 + var13 + 2), 0.0, 1.0, 1.0);
                var16.method_1688((double)entryStartX, (double)(var19 - 2), 0.0, 1.0, 0.0);
                var16.method_1688((double)entryEndX, (double)(var19 - 2), 0.0, 0.0, 0.0);
                var16.method_1698(0);
                var16.method_1688((double)(entryEndX + 1), (double)(var19 + var13 + 1), 0.0, 0.0, 1.0);
                var16.method_1688((double)(entryStartX - 1), (double)(var19 + var13 + 1), 0.0, 1.0, 1.0);
                var16.method_1688((double)(entryStartX - 1), (double)(var19 - 1), 0.0, 1.0, 0.0);
                var16.method_1688((double)(entryEndX + 1), (double)(var19 - 1), 0.0, 0.0, 0.0);
                var16.method_1685();
                GL11.glEnable((int)3553);
            }
            this.renderEntry(hoveredEntry, scrollAreaStartX, this.getWidgetRight() - this.getWidgetLeft() * 2, var19, var13, var16);
        }
        GL11.glDisable((int)2929);
        int var18 = 4;
        this.renderBars(0, this.top, 255, 255);
        this.renderBars(this.bottom, this.height, 255, 255);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3008);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)3553);
        var16.method_1695();
        var16.method_1692(0, 0);
        var16.method_1688((double)this.left, (double)(this.top + var18), 0.0, 0.0, 1.0);
        var16.method_1688((double)this.right, (double)(this.top + var18), 0.0, 1.0, 1.0);
        var16.method_1692(0, 255);
        var16.method_1688((double)this.right, (double)this.top, 0.0, 1.0, 0.0);
        var16.method_1688((double)this.left, (double)this.top, 0.0, 0.0, 0.0);
        var16.method_1685();
        var16.method_1695();
        var16.method_1692(0, 255);
        var16.method_1688((double)this.left, (double)this.bottom, 0.0, 0.0, 1.0);
        var16.method_1688((double)this.right, (double)this.bottom, 0.0, 1.0, 1.0);
        var16.method_1692(0, 0);
        var16.method_1688((double)this.right, (double)(this.bottom - var18), 0.0, 1.0, 0.0);
        var16.method_1688((double)this.left, (double)(this.bottom - var18), 0.0, 0.0, 0.0);
        var16.method_1685();
        var19 = this.getEntriesHeight() - (this.bottom - this.top - 4);
        if (var19 > 0) {
            int scrollbarHeight;
            var13 = (this.bottom - this.top) * (this.bottom - this.top) / this.getEntriesHeight();
            if (var13 < 32) {
                var13 = 32;
            }
            if (var13 > this.bottom - this.top - 8) {
                var13 = this.bottom - this.top - 8;
            }
            if ((scrollbarHeight = (int)this.scrollAmount * (this.bottom - this.top - var13) / var19 + this.top) < this.top) {
                scrollbarHeight = this.top;
            }
            var16.method_1695();
            var16.method_1692(0, 255);
            var16.method_1688((double)scrollbarStart, (double)this.bottom, 0.0, 0.0, 1.0);
            var16.method_1688((double)scrollbarEnd, (double)this.bottom, 0.0, 1.0, 1.0);
            var16.method_1688((double)scrollbarEnd, (double)this.top, 0.0, 1.0, 0.0);
            var16.method_1688((double)scrollbarStart, (double)this.top, 0.0, 0.0, 0.0);
            var16.method_1685();
            var16.method_1695();
            var16.method_1692(0x808080, 255);
            var16.method_1688((double)scrollbarStart, (double)(scrollbarHeight + var13), 0.0, 0.0, 1.0);
            var16.method_1688((double)scrollbarEnd, (double)(scrollbarHeight + var13), 0.0, 1.0, 1.0);
            var16.method_1688((double)scrollbarEnd, (double)scrollbarHeight, 0.0, 1.0, 0.0);
            var16.method_1688((double)scrollbarStart, (double)scrollbarHeight, 0.0, 0.0, 0.0);
            var16.method_1685();
            var16.method_1695();
            var16.method_1692(0xC0C0C0, 255);
            var16.method_1688((double)scrollbarStart, (double)(scrollbarHeight + var13 - 1), 0.0, 0.0, 1.0);
            var16.method_1688((double)(scrollbarEnd - 1), (double)(scrollbarHeight + var13 - 1), 0.0, 1.0, 1.0);
            var16.method_1688((double)(scrollbarEnd - 1), (double)scrollbarHeight, 0.0, 1.0, 0.0);
            var16.method_1688((double)scrollbarStart, (double)scrollbarHeight, 0.0, 0.0, 0.0);
            var16.method_1685();
        }
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
    }

    protected void renderBars(int start, int end, int lowerOpacity, int upperOpacity) {
        class_67 tessellator = class_67.field_2054;
        GL11.glBindTexture((int)3553, (int)this.minecraft.field_2814.method_1100("/gui/background.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float sizeOfSquareOnScreen = 32.0f;
        tessellator.method_1695();
        tessellator.method_1692(0x404040, upperOpacity);
        tessellator.method_1688(0.0, (double)end, 0.0, 0.0, (double)((float)end / sizeOfSquareOnScreen));
        tessellator.method_1688((double)this.width, (double)end, 0.0, (double)((float)this.width / sizeOfSquareOnScreen), (double)((float)end / sizeOfSquareOnScreen));
        tessellator.method_1692(0x404040, lowerOpacity);
        tessellator.method_1688((double)this.width, (double)start, 0.0, (double)((float)this.width / sizeOfSquareOnScreen), (double)((float)start / sizeOfSquareOnScreen));
        tessellator.method_1688(0.0, (double)start, 0.0, 0.0, (double)((float)start / sizeOfSquareOnScreen));
        tessellator.method_1685();
    }

    @Generated
    public void setScrollAmount(float scrollAmount) {
        this.scrollAmount = scrollAmount;
    }

    @Generated
    public float getScrollAmount() {
        return this.scrollAmount;
    }

    @Generated
    public void setDrawSelectedBox(boolean drawSelectedBox) {
        this.drawSelectedBox = drawSelectedBox;
    }

    @Generated
    public void setFirstEntryRenderOffset(int firstEntryRenderOffset) {
        this.firstEntryRenderOffset = firstEntryRenderOffset;
    }
}

