package net.glasslauncher.glassbrigadier.api.argument.coordinate;

import net.glasslauncher.glassbrigadier.api.command.GlassCommandSource;
import net.minecraft.class_189;
import net.minecraft.class_26;
import net.minecraft.class_63;
import org.lwjgl.util.vector.Vector2f;

public class Coordinate {
    final CoordinatePart x;
    final CoordinatePart y;
    final CoordinatePart z;

    Coordinate(CoordinatePart x, CoordinatePart y, CoordinatePart z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    /**
     * Get the {@link class_26} of the absolute position represented by this Coordinate.
     * @param commandSource the commandSource whose position will be used to resolve relative coordinates.
     * @return the {@link class_26} of the position.
     */
    public class_26 getVec3d(GlassCommandSource commandSource) {
        class_26 sourceCoords = commandSource.getPosition();
        if (this.x.type == CoordinateType.LOCAL) {
            return fromLocal(commandSource);
        }
        return class_26.method_1297(resolve(x, sourceCoords.field_1585), resolve(y, sourceCoords.field_1586), resolve(z, sourceCoords.field_1587));
    }

    /**
     * Get the {@link class_63} of the absolute position represented by this Coordinate.
     * @param commandSource the commandSource whose position will be used to resolve relative coordinates.
     * @return the {@link class_63} of the position.
     */
    public class_63 getVec3i(GlassCommandSource commandSource) {
        class_26 sourceCoords = commandSource.getPosition();
        if (this.x.type == CoordinateType.LOCAL) {
            class_26 res = fromLocal(commandSource);
            new class_63((int) res.field_1585, (int) res.field_1586, (int) res.field_1587);
        }
        return new class_63((int) resolve(x, sourceCoords.field_1585), (int) resolve(y, sourceCoords.field_1586), (int) resolve(z, sourceCoords.field_1587));
    }

    private class_26 fromLocal(GlassCommandSource source) {
        Vector2f vec2f = source.getRotation();
        class_26 vec3d = class_26.method_1297(source.getPosition().field_1585, source.getPosition().field_1586, source.getPosition().field_1587);
        float f = class_189.method_646((vec2f.y + 90.0F) * 0.017453292F);
        float g = class_189.method_644((vec2f.y + 90.0F) * 0.017453292F);
        float h = class_189.method_646(-vec2f.x * 0.017453292F);
        float i = class_189.method_644(-vec2f.x * 0.017453292F);
        float j = class_189.method_646((-vec2f.x + 90.0F) * 0.017453292F);
        float k = class_189.method_644((-vec2f.x + 90.0F) * 0.017453292F);
        class_26 vec3d2 = class_26.method_1297(f * h, i, g * h);
        class_26 vec3d3 = class_26.method_1297(f * j, k, g * j);
        class_26 vec3d4 = multiply(crossProduct(vec3d2, vec3d3), -1.0D);
        double d = vec3d2.field_1585 * this.z.coord + vec3d3.field_1585 * this.y.coord + vec3d4.field_1585 * this.x.coord;
        double e = vec3d2.field_1586 * this.z.coord + vec3d3.field_1586 * this.y.coord + vec3d4.field_1586 * this.x.coord;
        double l = vec3d2.field_1587 * this.z.coord + vec3d3.field_1587 * this.y.coord + vec3d4.field_1587 * this.x.coord;
        return class_26.method_1297((vec3d.field_1585 + d), (vec3d.field_1586 + e), (vec3d.field_1587 + l));
    }

    private static class_26 multiply(class_26 original, double amount) {
        return class_26.method_1297(original.field_1585*amount, original.field_1586*amount, original.field_1587*amount);
    }

    private static class_26 crossProduct(class_26 orig, class_26 arg) {
        return class_26.method_1297(orig.field_1586 * arg.field_1587 - orig.field_1587 * arg.field_1586, orig.field_1587 * arg.field_1585 - orig.field_1585 * arg.field_1587, orig.field_1585 * arg.field_1586 - orig.field_1586 * arg.field_1585);
    }

    private static double resolve(CoordinatePart part, double relativeTo) {
        return part.type == CoordinateType.RELATIVE ? part.coord + relativeTo : part.coord;
    }

    public static class CoordinatePart {
        final double coord;
        final CoordinateType type;

        public CoordinatePart(double coord, CoordinateType type) {
            this.coord = coord;
            this.type = type;
        }

        /**
         * Checks that either all are {@link CoordinateType#LOCAL LOCAL}, or none are.
         *
         * @param x the first coordinate part
         * @param y the second coordinate part
         * @param z the third coordinate part
         *
         * @return whether all three match in locality
         */
        public static boolean allMatchLocality(CoordinatePart x, CoordinatePart y, CoordinatePart z) {
            return (x.type != CoordinateType.LOCAL || y.type == CoordinateType.LOCAL && z.type == CoordinateType.LOCAL)
                    && (y.type != CoordinateType.LOCAL || x.type == CoordinateType.LOCAL)
                    && (z.type != CoordinateType.LOCAL || x.type == CoordinateType.LOCAL);
        }
    }

    public enum CoordinateType {
        ABSOLUTE,
        RELATIVE,
        LOCAL
    }
}
