package net.glasslauncher.glassbrigadier.api.argument.tileid;

import net.minecraft.class_17;
import net.modificationstation.stationapi.api.registry.BlockRegistry;
import net.modificationstation.stationapi.api.util.Identifier;

public class BlockId {
    public final int numericId;
    public final Identifier id;

    BlockId(int numericId) {
        this.numericId = numericId;
        class_17 block = BlockRegistry.INSTANCE.get(numericId);
        this.id = BlockRegistry.INSTANCE.getId(block);
    }

    BlockId(String idString) {
        this.id = Identifier.of(idString);
        class_17 block = BlockRegistry.INSTANCE.get(id);
        if (block != null) {
            this.numericId = block.field_1915;
            return;
        }
        try {
            this.numericId = Integer.parseInt(idString);
        } catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid block ID!");
        }
    }
}
