package net.glasslauncher.glassbrigadier.api.command;

import net.glasslauncher.glassbrigadier.api.permission.PermissionNodeInstance;
import net.glasslauncher.glassbrigadier.api.storage.player.PlayerStorageFile;
import net.minecraft.class_18;
import net.minecraft.class_26;
import net.minecraft.class_54;
import net.minecraft.class_57;
import org.lwjgl.util.vector.Vector2f;

import javax.annotation.Nullable;
import java.util.List;
import java.util.Set;

public interface GlassCommandSource {

    // Vanilla method, update with mappings.
    void sendFeedback(String message);

    // Vanilla method, update with mappings.
    String getSourceName();

    class_18 getWorld();

    class_26 getPosition();

    Vector2f getRotation();

    Set<PermissionNodeInstance<?>> getPermissions();

    boolean satisfiesNode(PermissionNodeInstance<?> nodeToCheck);

    class_57 getEntity();

    @Nullable
    class_54 getPlayer();

    @Nullable
    class_54 getPlayerByName(String playerName);

    default void sendMessageToPlayer(String playerName, String message) {
        sendMessageToPlayer(getPlayerByName(playerName), message);
    }

    default void sendMessageToPlayer(@Nullable class_54 player, String message) {
        if (player == null) {
            return;
        }

        player.method_490(message);
    }

    List<class_54> getAllPlayers();

    @Nullable
    PlayerStorageFile getStorage();

    boolean isOp();
}
