package net.glasslauncher.glassbrigadier.api.storage;

import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.glasslauncher.glassbrigadier.GlassBrigadier;
import net.minecraft.class_54;
import net.minecraft.class_81;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.modificationstation.stationapi.api.registry.DimensionRegistry;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.Namespace;

import java.io.File;

public class StorageUtils {

    public static File getPlayerStorageFile(String playerName) {
        return new File(getPlayersDir(), playerName + "." + GlassBrigadier.NAMESPACE + ".yaml");
    }

    public static File getPlayerStorageFile(class_54 player) {
        return new File(getPlayersDir(), player.field_528 + "." + GlassBrigadier.NAMESPACE + ".yaml");
    }

    public static File getModStorageFile(Identifier identifier) {
        return new File(getWorldDir(), GlassBrigadier.NAMESPACE + "_storages/" + identifier.namespace + "/" + identifier.path + ".yaml");
    }


    public static File getPlayersDir() {
        return getWorldStorage().field_280;
    }

    public static File getWorldDir() {
        return getWorldStorage().field_279;
    }

    public static class_81 getWorldStorage() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            return (class_81) Minecraft.field_2791.field_2804.field_219;
        }

        //noinspection deprecation
        MinecraftServer server = (MinecraftServer) FabricLoader.getInstance().getGameInstance();
        //noinspection OptionalGetWithoutIsPresent If this is null, we're ALL fucked.
        return (class_81) server.method_2157(DimensionRegistry.INSTANCE.getLegacyId(Identifier.of(Namespace.MINECRAFT, "overworld")).getAsInt()).field_219;
    }
}
