package net.glasslauncher.glassbrigadier.impl.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.glasslauncher.glassbrigadier.api.command.CommandProvider;
import net.glasslauncher.glassbrigadier.api.command.GlassCommandSource;
import net.glasslauncher.glassbrigadier.api.storage.player.PlayerStorageFile;
import net.glasslauncher.glassbrigadier.impl.argument.GlassArgumentBuilder;
import net.minecraft.class_54;
import net.minecraft.class_69;
import net.modificationstation.stationapi.api.util.Formatting;
import org.simpleyaml.configuration.ConfigurationSection;

import java.util.List;

import static com.mojang.brigadier.arguments.StringArgumentType.word;
import static net.glasslauncher.glassbrigadier.api.predicate.HasPermission.booleanPermission;
import static net.glasslauncher.glassbrigadier.api.predicate.IsPlayer.isPlayer;

public class HomeCommand implements CommandProvider {
    @Override
    public LiteralArgumentBuilder<GlassCommandSource> get() {
        return GlassArgumentBuilder.literal("home")
                .requires(source -> isPlayer().test(source) && booleanPermission("command.home").test(source))
                .executes(this::home)
                .then(GlassArgumentBuilder.argument("name", word())
                        .executes(this::homeNamed)
                );
    }

    public int homeNamed(CommandContext<GlassCommandSource> context) {
        home(context, context.getArgument("name", String.class));
        return 0;
    }

    public int home(CommandContext<GlassCommandSource> context) {
        home(context, "home");
        return 0;
    }

    public void home(CommandContext<GlassCommandSource> context, String name) {
        PlayerStorageFile playerStorage = context.getSource().getStorage();
        ConfigurationSection homes = playerStorage.getNotNullSection("homes");
        List<Double> homeLoc = homes.getDoubleList(name);

        if (homeLoc == null || homeLoc.isEmpty()) {
            context.getSource().sendFeedback(Formatting.RED + "No home named \"" + name + "\".");
            return;
        }

        if (context.getSource().getPlayer() instanceof class_69 serverPlayerEntity) {
            serverPlayerEntity.field_255.method_832(homeLoc.get(0), homeLoc.get(1), homeLoc.get(2), serverPlayerEntity.field_1606, serverPlayerEntity.field_1607);
        }
        else {
            class_54 player = context.getSource().getPlayer();
            player.method_1341(homeLoc.get(0), homeLoc.get(1), homeLoc.get(2), player.field_1606, player.field_1607);
        }

        context.getSource().sendFeedback("Teleported to home \"" + name + "\".");
    }
}
