package net.glasslauncher.glassbrigadier.impl.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.glasslauncher.glassbrigadier.api.argument.tileid.BlockId;
import net.glasslauncher.glassbrigadier.api.command.CommandProvider;
import net.glasslauncher.glassbrigadier.api.command.GlassCommandSource;
import net.glasslauncher.glassbrigadier.impl.argument.GlassArgumentBuilder;
import net.minecraft.class_63;

import static com.mojang.brigadier.arguments.IntegerArgumentType.getInteger;
import static com.mojang.brigadier.arguments.IntegerArgumentType.integer;
import static net.glasslauncher.glassbrigadier.api.argument.coordinate.CoordinateArgumentType.getCoordinate;
import static net.glasslauncher.glassbrigadier.api.argument.coordinate.CoordinateArgumentType.intCoordinate;
import static net.glasslauncher.glassbrigadier.api.argument.tileid.BlockIdArgumentType.getTileId;
import static net.glasslauncher.glassbrigadier.api.argument.tileid.BlockIdArgumentType.tileId;
import static net.glasslauncher.glassbrigadier.api.predicate.HasPermission.booleanPermission;

public class SetTileCommand implements CommandProvider {
    @Override
    public LiteralArgumentBuilder<GlassCommandSource> get() {
        return GlassArgumentBuilder.literal("settile")
                .requires(booleanPermission("command.settile"))
                .then(GlassArgumentBuilder.argument("pos", intCoordinate())
                        .then(GlassArgumentBuilder.argument("id", tileId())
                                .executes(this::placeBlock)
                                .then(GlassArgumentBuilder.argument("meta", integer())
                                        .executes(this::placeBlockWithMeta)
                                )
                        )
                );
    }

    public int placeBlock(CommandContext<GlassCommandSource> context) {
        class_63 pos = getCoordinate(context, "pos").getVec3i(context.getSource());
        BlockId tile = getTileId(context, "id");
        (context.getSource()).getWorld().method_229(pos.field_1482, pos.field_1483, pos.field_1484, tile.numericId);
        sendFeedbackAndLog(context.getSource(), "Set block at " + pos.field_1482 + " " + pos.field_1483 + " " + pos.field_1484 + " to " + tile.numericId);
        return 0;
    }

    public int placeBlockWithMeta(CommandContext<GlassCommandSource> context) {
        class_63 pos = getCoordinate(context, "pos").getVec3i(context.getSource());
        BlockId tile = getTileId(context, "id");
        int meta = getInteger(context, "meta");
        (context.getSource()).getWorld().method_201(pos.field_1482, pos.field_1483, pos.field_1484, tile.numericId, meta);
        sendFeedbackAndLog(context.getSource(), "Set block at " + pos.field_1482 + " " + pos.field_1483 + " " + pos.field_1484 + " to " + tile.numericId + ":" + meta);
        return 0;
    }
}
