package net.glasslauncher.glassbrigadier.impl.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.glasslauncher.glassbrigadier.api.argument.entityid.EntityType;
import net.glasslauncher.glassbrigadier.api.command.CommandProvider;
import net.glasslauncher.glassbrigadier.api.command.GlassCommandSource;
import net.glasslauncher.glassbrigadier.impl.argument.GlassArgumentBuilder;
import net.minecraft.class_18;
import net.minecraft.class_206;
import net.minecraft.class_26;
import net.minecraft.class_57;

import static net.glasslauncher.glassbrigadier.api.argument.coordinate.CoordinateArgumentType.coordinate;
import static net.glasslauncher.glassbrigadier.api.argument.coordinate.CoordinateArgumentType.getCoordinate;
import static net.glasslauncher.glassbrigadier.api.argument.entityid.EntityTypeArgumentType.entityType;
import static net.glasslauncher.glassbrigadier.api.argument.entityid.EntityTypeArgumentType.getEntityType;
import static net.glasslauncher.glassbrigadier.api.predicate.HasPermission.booleanPermission;

public class SummonCommand implements CommandProvider {
    @Override
    public LiteralArgumentBuilder<GlassCommandSource> get() {
        return GlassArgumentBuilder.literal("summon")
                .requires(booleanPermission("command.summon"))
                .then(GlassArgumentBuilder.argument("id", entityType())
                        .then(GlassArgumentBuilder.argument("pos", coordinate())
                                .executes(this::summonEntity)
                        )
                );
    }

    public int summonEntity(CommandContext<GlassCommandSource> context) {
        class_26 pos = getCoordinate(context, "pos").getVec3d(context.getSource());
        class_18 world = context.getSource().getWorld();
        EntityType entityType = getEntityType(context, "id");
        class_57 entity = class_206.method_732(entityType.id(), world);
        entity.method_1340(pos.field_1585, pos.field_1586, pos.field_1587);
        world.method_210(entity);
        sendFeedbackAndLog(context.getSource(), "Summoned " + entityType.id() + " at " + pos.field_1585 + " " + pos.field_1586 + " " + pos.field_1587);
        return 0;
    }
}
