package net.glasslauncher.glassbrigadier.impl.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.glasslauncher.glassbrigadier.GlassBrigadier;
import net.glasslauncher.glassbrigadier.api.command.CommandProvider;
import net.glasslauncher.glassbrigadier.api.command.GlassCommandSource;
import net.glasslauncher.glassbrigadier.api.predicate.HasPermission;
import net.glasslauncher.glassbrigadier.api.storage.world.WorldModStorageFile;
import net.glasslauncher.glassbrigadier.impl.argument.GlassArgumentBuilder;
import net.minecraft.class_54;
import net.minecraft.class_69;
import net.modificationstation.stationapi.api.util.Formatting;
import org.simpleyaml.configuration.ConfigurationSection;
import org.simpleyaml.configuration.MemorySection;

import java.util.List;

import static com.mojang.brigadier.arguments.StringArgumentType.word;
import static net.glasslauncher.glassbrigadier.api.predicate.HasPermission.booleanPermission;
import static net.glasslauncher.glassbrigadier.api.predicate.IsPlayer.isPlayer;

public class WarpCommand implements CommandProvider {
    @Override
    public LiteralArgumentBuilder<GlassCommandSource> get() {
        HasPermission hasPermission = booleanPermission("command.warp");
        return GlassArgumentBuilder.literal("warp")
                .requires(source -> isPlayer().test(source) && hasPermission.test(source))
                .then(GlassArgumentBuilder.argument("name", word())
                        .executes(this::warp)
                );
    }

    public int warp(CommandContext<GlassCommandSource> context) {
        String name = context.getArgument("name", String.class);

        WorldModStorageFile serverStorage = WorldModStorageFile.of(GlassBrigadier.NAMESPACE.id("warps"));
        MemorySection warps = (MemorySection) serverStorage.get("warps");
        ConfigurationSection warp = (ConfigurationSection) warps.get(name);

        if (warp == null) {
            context.getSource().sendFeedback(Formatting.RED + "No warp named \"" + name + "\".");
            return 0;
        }

        List<Double> warpLoc = warp.getDoubleList("location");

        if (context.getSource().getPlayer() instanceof class_69 serverPlayerEntity) {
            serverPlayerEntity.field_255.method_832(warpLoc.get(0), warpLoc.get(1), warpLoc.get(2), serverPlayerEntity.field_1606, serverPlayerEntity.field_1607);
        }
        else {
            class_54 player = context.getSource().getPlayer();
            player.method_1341(warpLoc.get(0), warpLoc.get(1), warpLoc.get(2), player.field_1606, player.field_1607);
        }

        context.getSource().sendFeedback("Warped to \"" + name + "\".");
        return 0;
    }
}
