package net.glasslauncher.glassbrigadier.impl.command.vanilla;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.glasslauncher.glassbrigadier.api.command.CommandProvider;
import net.glasslauncher.glassbrigadier.api.command.GlassCommandSource;
import net.glasslauncher.glassbrigadier.api.entity.EntityUtils;
import net.glasslauncher.glassbrigadier.impl.argument.GlassArgumentBuilder;
import net.minecraft.class_26;
import net.minecraft.class_57;
import net.minecraft.class_69;
import java.util.List;

import static net.glasslauncher.glassbrigadier.api.argument.coordinate.CoordinateArgumentType.coordinate;
import static net.glasslauncher.glassbrigadier.api.argument.coordinate.CoordinateArgumentType.getCoordinate;
import static net.glasslauncher.glassbrigadier.api.argument.playerselector.TargetSelectorArgumentType.*;
import static net.glasslauncher.glassbrigadier.api.predicate.HasPermission.booleanPermission;
import static net.glasslauncher.glassbrigadier.api.predicate.IsPlayer.isPlayer;

public class TeleportCommand implements CommandProvider {
    @Override
    public LiteralArgumentBuilder<GlassCommandSource> get() {
        return GlassArgumentBuilder.literal("tp")
                .requires(booleanPermission("command.tp"))
                .then(GlassArgumentBuilder.argument("pos", coordinate())
                        .requires(isPlayer())
                        .executes(this::teleportToPosition)
                )
                .then(GlassArgumentBuilder.argument("target", entity())
                        .requires(isPlayer())
                        .executes(this::teleportToEntity)
                )
                .then(GlassArgumentBuilder.argument("teleportees", entities())
                        .then(GlassArgumentBuilder.argument("pos", coordinate())
                                .executes(this::teleportOtherToPosition)
                        )
                        .then(GlassArgumentBuilder.argument("target", entity())
                                .executes(this::teleportOtherToEntity)
                        )
                );
    }

    private int teleportToPosition(CommandContext<GlassCommandSource> ctx) {
        GlassCommandSource sender = ctx.getSource();
        class_26 position = getCoordinate(ctx, "pos").getVec3d(sender);
        this.teleport(sender.getEntity(), position, sender.getEntity().field_1606, sender.getEntity().field_1607, sender);
        return 1;
    }

    private int teleportToEntity(CommandContext<GlassCommandSource> ctx) {
        GlassCommandSource sender = ctx.getSource();
        class_57 target = getEntities(ctx, "target").getEntities(sender).get(0);
        this.teleport(sender.getEntity(), EntityUtils.getPosition(target), target.field_1606, target.field_1607, sender);
        return 1;
    }

    private int teleportOtherToPosition(CommandContext<GlassCommandSource> ctx) {
        GlassCommandSource sender = ctx.getSource();
        List<class_57> teleportees = getEntities(ctx, "teleportees").getEntities(sender);
        class_26 position = getCoordinate(ctx, "pos").getVec3d(sender);
        teleportees.forEach(e -> this.teleport(e, position, e.field_1606, e.field_1607, sender));
        return teleportees.size();
    }

    private int teleportOtherToEntity(CommandContext<GlassCommandSource> ctx) {
        GlassCommandSource sender = ctx.getSource();
        List<class_57> teleportees = getEntities(ctx, "teleportees").getEntities(sender);
        class_57 target = getEntities(ctx, "target").getEntities(sender).get(0);
        teleportees.forEach(e -> this.teleport(e, EntityUtils.getPosition(target), e.field_1606, e.field_1607, sender));
        return teleportees.size();
    }

    private void teleport(class_57 entity, class_26 position, float yaw, float pitch, GlassCommandSource sender) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER && entity instanceof class_69 serverPlayerEntity) {
            serverPlayerEntity.field_255.method_832(position.field_1585, position.field_1586, position.field_1587, yaw, pitch);
        } else {
            entity.method_1341(position.field_1585, position.field_1586, position.field_1587, yaw, pitch);
        }

        this.sendFeedbackAndLog(sender, String.format("Teleporting %s to %s (%f %f)", EntityUtils.getName(entity), position, yaw, pitch));
    }
}
