package net.glasslauncher.glassbrigadier.impl.command.vanilla.server;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.loader.api.FabricLoader;
import net.glasslauncher.glassbrigadier.api.command.CommandProvider;
import net.glasslauncher.glassbrigadier.api.command.GlassCommandSource;
import net.glasslauncher.glassbrigadier.impl.argument.GlassArgumentBuilder;
import net.glasslauncher.glassbrigadier.impl.argument.GlassCommandBuilder;
import net.minecraft.class_166;
import net.minecraft.class_69;
import net.minecraft.server.MinecraftServer;
import net.modificationstation.stationapi.api.util.Formatting;

import static net.glasslauncher.glassbrigadier.api.predicate.HasPermission.booleanPermission;

public class BanCommand implements CommandProvider {
    @Override
    public LiteralArgumentBuilder<GlassCommandSource> get() {
        return GlassCommandBuilder.literal("ban", "Ban a given player.")
                .requires(booleanPermission("command.ban"))
                .then(GlassArgumentBuilder.argument("player", StringArgumentType.word())
                        .executes(this::banPlayer)
                );
    }

    public int banPlayer(CommandContext<GlassCommandSource> context) {
        String player = context.getArgument("player", String.class);

        //noinspection deprecation
        class_166 playerManager = ((MinecraftServer) FabricLoader.getInstance().getGameInstance()).field_2842;
        if (playerManager.field_582.contains(player.toLowerCase().strip())) {
            context.getSource().sendFeedback(Formatting.RED + player + " is already banned!");
            return 0;
        }

        playerManager.method_561(player);
        class_69 playerEntity = ((class_69) context.getSource().getPlayerByName(player));
        if (playerEntity != null) {
            playerEntity.field_255.method_833(Formatting.RED + "Banned by admin.");
        }
        sendFeedbackAndLog(context.getSource(), "Banned " + player + ".");

        return 0;
    }
}
