package net.glasslauncher.glassbrigadier.impl.command.vanilla.server;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.loader.api.FabricLoader;
import net.glasslauncher.glassbrigadier.api.command.CommandProvider;
import net.glasslauncher.glassbrigadier.api.command.GlassCommandSource;
import net.glasslauncher.glassbrigadier.impl.argument.GlassArgumentBuilder;
import net.glasslauncher.glassbrigadier.impl.argument.GlassCommandBuilder;
import net.minecraft.class_166;
import net.minecraft.class_69;
import net.minecraft.server.MinecraftServer;
import net.modificationstation.stationapi.api.util.Formatting;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.regex.Pattern;

import static com.mojang.brigadier.arguments.StringArgumentType.getString;
import static com.mojang.brigadier.arguments.StringArgumentType.word;
import static net.glasslauncher.glassbrigadier.api.predicate.HasPermission.booleanPermission;

public class BanIpCommand implements CommandProvider {
    public static final Pattern IP_REGEX = Pattern.compile("(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)");

    @Override
    public LiteralArgumentBuilder<GlassCommandSource> get() {
        return GlassCommandBuilder.literal("ban-ip", "Ban an IP.")
                .requires(booleanPermission("command.banip"))
                .then(GlassArgumentBuilder.argument("ip", word())
                        .executes(this::banIp)
                );
    }

    public int banIp(CommandContext<GlassCommandSource> context) {
        String ip = getString(context, "ip").toLowerCase().strip();

        if (!IP_REGEX.matcher(ip).matches()) {
            context.getSource().sendFeedback(Formatting.RED + ip + " isn't a valid IP address!");
            return 0;
        }
        //noinspection deprecation
        class_166 playerManager = ((MinecraftServer) FabricLoader.getInstance().getGameInstance()).field_2842;

        if (playerManager.field_583.contains(ip)) {
            context.getSource().sendFeedback(Formatting.RED + ip + " is already banned!");
            return 0;
        }

        //noinspection unchecked
        for (class_69 player : new ArrayList<class_69>(playerManager.field_578)) {
            if (((InetSocketAddress) player.field_255.field_917.method_1131()).getHostString().equals(ip)) {
                player.field_255.method_833(Formatting.RED + "Banned by admin.");
            }
        }

        playerManager.method_570(ip);
        sendFeedbackAndLog(context.getSource(), "IP banned " + ip + ".");
        return 0;
    }
}
