package net.glasslauncher.glassbrigadier.impl.command.vanilla.server;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.loader.api.FabricLoader;
import net.glasslauncher.glassbrigadier.api.argument.playerselector.TargetSelectorArgumentType;
import net.glasslauncher.glassbrigadier.api.command.CommandProvider;
import net.glasslauncher.glassbrigadier.api.command.GlassCommandSource;
import net.glasslauncher.glassbrigadier.impl.argument.GlassArgumentBuilder;
import net.glasslauncher.glassbrigadier.impl.argument.GlassCommandBuilder;
import net.minecraft.class_166;
import net.minecraft.server.MinecraftServer;
import net.modificationstation.stationapi.api.util.Formatting;

import static net.glasslauncher.glassbrigadier.api.argument.playerselector.TargetSelectorArgumentType.getPlayers;
import static net.glasslauncher.glassbrigadier.api.predicate.HasPermission.booleanPermission;

public class PardonCommand implements CommandProvider {
    @Override
    public LiteralArgumentBuilder<GlassCommandSource> get() {
        return GlassCommandBuilder.literal("pardon", "Unban a player.")
                .alias("unban")
                .requires(booleanPermission("command.pardon"))
                .then(GlassArgumentBuilder.argument("player", TargetSelectorArgumentType.entity())
                        .executes(this::pardonPlayer)
                );
    }

    public int pardonPlayer(CommandContext<GlassCommandSource> context) {
        getPlayers(context, "player").getEntities(context.getSource()).forEach(player -> {
            //noinspection deprecation
            class_166 playerManager = ((MinecraftServer) FabricLoader.getInstance().getGameInstance()).field_2842;
            if (!playerManager.field_582.contains(player.field_528.toLowerCase().strip())) {
                context.getSource().sendFeedback(Formatting.RED + player.field_528 + " isn't banned!");
                return;
            }
            playerManager.method_567(player.field_528);
            sendFeedbackAndLog(context.getSource(), "Unbanned " + player.field_528 + ".");
        });
        return 0;
    }
}
