package net.glasslauncher.glassbrigadier.impl.command.vanilla.server;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.loader.api.FabricLoader;
import net.glasslauncher.glassbrigadier.api.command.CommandProvider;
import net.glasslauncher.glassbrigadier.api.command.GlassCommandSource;
import net.glasslauncher.glassbrigadier.impl.argument.GlassCommandBuilder;
import net.minecraft.class_18;
import net.minecraft.server.MinecraftServer;
import net.modificationstation.stationapi.api.util.Formatting;

import static net.glasslauncher.glassbrigadier.api.predicate.HasPermission.booleanPermission;

public class SaveAllCommand implements CommandProvider {
    @Override
    public LiteralArgumentBuilder<GlassCommandSource> get() {
        return GlassCommandBuilder.literal("save-all", "Forces a save of all the loaded levels in the world.")
                .requires(booleanPermission("command.saveall"))
                .executes(this::saveAll);
    }

    public int saveAll(CommandContext<GlassCommandSource> context) {
        sendFeedbackAndLog(context.getSource(), Formatting.YELLOW + "Forcing save..");
        //noinspection deprecation
        MinecraftServer minecraftServer = (MinecraftServer) FabricLoader.getInstance().getGameInstance();
        if (minecraftServer.field_2842 != null) {
            minecraftServer.field_2842.method_571();
        }

        for (class_18 world : minecraftServer.field_2841) {
            world.method_195(true, null);
        }

        sendFeedbackAndLog(context.getSource(), Formatting.YELLOW + "Save complete.");
        return 0;
    }
}
