package net.glasslauncher.glassbrigadier.impl.command.vanilla.server;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.loader.api.FabricLoader;
import net.glasslauncher.glassbrigadier.api.command.CommandProvider;
import net.glasslauncher.glassbrigadier.api.command.GlassCommandSource;
import net.glasslauncher.glassbrigadier.impl.argument.GlassCommandBuilder;
import net.minecraft.class_73;
import net.minecraft.server.MinecraftServer;
import net.modificationstation.stationapi.api.util.Formatting;

import static net.glasslauncher.glassbrigadier.api.predicate.HasPermission.booleanPermission;

public class SaveOffCommand implements CommandProvider {
    @Override
    public LiteralArgumentBuilder<GlassCommandSource> get() {
        return GlassCommandBuilder.literal("save-off", "Turn off server saving until turned back on, or next reboot.")
                .requires(booleanPermission("command.saveoff"))
                .executes(this::saveOff);
    }

    public int saveOff(CommandContext<GlassCommandSource> context) {
        //noinspection deprecation
        MinecraftServer minecraftServer = (MinecraftServer) FabricLoader.getInstance().getGameInstance();
        for (class_73 world : minecraftServer.field_2841) {
            world.field_275 = true;
        }

        sendFeedbackAndLog(context.getSource(), Formatting.YELLOW + "Level saving disabled.");
        return 0;
    }
}
