package net.glasslauncher.glassbrigadier.mixin.client.vanillajank;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.glasslauncher.glassbrigadier.GlassBrigadier;
import net.glasslauncher.glassbrigadier.api.command.GlassCommandSource;
import net.minecraft.class_18;
import net.minecraft.class_40;
import net.minecraft.class_54;
import net.minecraft.client.Minecraft;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_40.class)
public abstract class MakeClientPlayerSendMessages extends class_54 {

    @Shadow protected Minecraft minecraft;

    public MakeClientPlayerSendMessages(class_18 world) {
        super(world);
    }

    @Inject(method = "sendChatMessage", at = @At("HEAD"))
    void test(String message, CallbackInfo ci) {
        if (field_1596.field_180) {
            return;
        }
        if (GlassBrigadier.CONFIG.singlePlayerCommands && message.startsWith("/")) {
            try {
                GlassBrigadier.dispatcher.execute(message.substring(1), (GlassCommandSource) minecraft);
            } catch (CommandSyntaxException e) {
                minecraft.field_2820.method_1949(e.getMessage());
            }
            return;
        }
        minecraft.field_2820.method_1949("<" + field_528 + "> " + message.strip());
    }

}
