package net.glasslauncher.glassbrigadier.mixin.commandsource;

import net.glasslauncher.glassbrigadier.api.command.GlassCommandSource;
import net.glasslauncher.glassbrigadier.api.permission.PermissionNodeInstance;
import net.glasslauncher.glassbrigadier.api.storage.player.PlayerStorageFile;
import net.glasslauncher.glassbrigadier.impl.permission.UserPermissionManagerImpl;
import net.minecraft.class_18;
import net.minecraft.class_26;
import net.minecraft.class_40;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.minecraft.client.Minecraft;
import org.lwjgl.util.vector.Vector2f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

import javax.annotation.Nullable;
import java.util.List;
import java.util.Set;

@SuppressWarnings("AddedMixinMembersNamePattern")
@Mixin(Minecraft.class)
public class ExtendedMinecraft implements GlassCommandSource {

    @Shadow public class_40 player;

    @Override
    public void sendFeedback(String message) {
        class_54 playerEntity = getPlayer();
        if (playerEntity != null) {
            playerEntity.method_490(message);
        }
    }

    @Override
    public String getSourceName() {
        class_54 playerEntity = getPlayer();
        if (playerEntity != null) {
            return playerEntity.field_528;
        }
        return "Minecraft";
    }

    @Override
    public class_18 getWorld() {
        if (getPlayer() != null) {
            return getPlayer().field_1596;
        }
        return null;
    }

    @Override
    public class_26 getPosition() {
        class_54 player = getPlayer();
        if (player != null) {
            return class_26.method_1297(player.field_1600, player.field_1601, player.field_1602);
        }

        return class_26.method_1297(0, 0, 0);
    }

    @Override
    public Vector2f getRotation() {
        class_54 player = getPlayer();
        if (player != null) {
            return new Vector2f(player.field_1607, player.field_1606);
        }
        return new Vector2f(0f, 0f);
    }

    @Override
    public Set<PermissionNodeInstance<?>> getPermissions() {
        return UserPermissionManagerImpl.getNodes(getSourceName());
    }

    @Override
    public boolean satisfiesNode(PermissionNodeInstance<?> nodeToCheck) {
        return true;
    }

    @Override
    public class_57 getEntity() {
        return getPlayer();
    }

    @Nullable
    @Override
    public class_54 getPlayer() {
        return player;
    }

    @Override
    public @Nullable class_54 getPlayerByName(String playerName) {
        return player != null && playerName.equals(player.field_528) ? player : null;
    }

    @Override
    public void sendMessageToPlayer(String playerName, String message) {
        class_54 player = getPlayerByName(playerName);
        if (player == null) {
            return;
        }

        player.method_490(message);
    }

    @Override
    public void sendMessageToPlayer(@Nullable class_54 player, String message) {
        if (player == null) {
            return;
        }

        player.method_490(message);

    }

    @Override
    public List<class_54> getAllPlayers() {
        return List.of(player);
    }

    @Override
    public PlayerStorageFile getStorage() {
        return PlayerStorageFile.of(getPlayer());
    }

    @Override
    public boolean isOp() {
        return true;
    }
}
