package net.glasslauncher.glassbrigadier.mixin.commandsource;

import net.glasslauncher.glassbrigadier.api.command.GlassCommandSource;
import net.glasslauncher.glassbrigadier.api.permission.PermissionNodeInstance;
import net.glasslauncher.glassbrigadier.api.storage.player.PlayerStorageFile;
import net.minecraft.class_166;
import net.minecraft.class_18;
import net.minecraft.class_26;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.minecraft.class_73;
import net.minecraft.server.MinecraftServer;
import net.modificationstation.stationapi.api.registry.DimensionRegistry;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.Namespace;
import org.lwjgl.util.vector.Vector2f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

import javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@SuppressWarnings("AddedMixinMembersNamePattern")
@Mixin(MinecraftServer.class)
public class ExtendedMinecraftServer implements GlassCommandSource {

    @Shadow public class_166 playerManager;

    @Shadow public class_73 getWorld(int dimensionId) { throw new AssertionError(); }

    @Shadow public void sendMessage(String message) {}

    @Shadow public String getName() {throw new AssertionError(); }

    @Override
    public void sendFeedback(String message) {
        sendMessage(message);
    }

    @Override
    public String getSourceName() {
        return getName();
    }

    @Override
    public class_18 getWorld() {
        //noinspection DataFlowIssue
        return getWorld(DimensionRegistry.INSTANCE.get(Identifier.of(Namespace.MINECRAFT, "overworld")).getLegacyID());
    }

    @Override
    public class_26 getPosition() {
        class_54 player = getPlayer();
        if (player != null) {
            return class_26.method_1297(player.field_1600, player.field_1601, player.field_1602);
        }

        return class_26.method_1297(0, 0, 0);
    }

    @Override
    public Vector2f getRotation() {
        class_54 player = getPlayer();
        if (player != null) {
            return new Vector2f(player.field_1607, player.field_1606);
        }
        return new Vector2f(0f, 0f);
    }

    @Override
    public Set<PermissionNodeInstance<?>> getPermissions() {
        return Set.of();
    }

    @Override
    public boolean satisfiesNode(PermissionNodeInstance<?> nodeToCheck) {
        return true;
    }

    @Override
    public class_57 getEntity() {
        return null;
    }

    @Nullable
    @Override
    public class_54 getPlayer() {
        return null;
    }

    @Override
    public @Nullable class_54 getPlayerByName(String playerName) {
        return playerManager.method_586(playerName);
    }

    @Override
    public List<class_54> getAllPlayers() {
        //noinspection unchecked
        return new ArrayList<class_54>(playerManager.field_578);
    }

    @Override
    public @Nullable PlayerStorageFile getStorage() {
        return null;
    }

    @Override
    public boolean isOp() {
        return true;
    }
}
