package net.glasslauncher.glassbrigadier.mixin.commandsource;

import net.glasslauncher.glassbrigadier.api.command.GlassCommandSource;
import net.glasslauncher.glassbrigadier.api.permission.PermissionNodeInstance;
import net.glasslauncher.glassbrigadier.api.storage.player.PlayerStorageFile;
import net.glasslauncher.glassbrigadier.impl.permission.UserPermissionManagerImpl;
import net.minecraft.class_11;
import net.minecraft.class_18;
import net.minecraft.class_26;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.minecraft.class_69;
import net.minecraft.server.MinecraftServer;
import org.lwjgl.util.vector.Vector2f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

import javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@SuppressWarnings("AddedMixinMembersNamePattern")
@Mixin(class_11.class)
public class ExtendedServerPlayNetworkHandler implements GlassCommandSource {

    @Shadow public class_69 player;

    @Shadow public MinecraftServer server;

    @Shadow public String getName() { throw new AssertionError(); }

    @Shadow public void sendMessage(String message) {}

    @Override
    public String getSourceName() {
        return getName();
    }

    @Override
    public void sendFeedback(String message) {
        sendMessage(message);
    }

    @Override
    public class_18 getWorld() {
        if (getPlayer() != null) {
            return getPlayer().field_1596;
        }
        return null;
    }

    @Override
    public class_26 getPosition() {
        class_54 player = getPlayer();
        if (player != null) {
            return class_26.method_1297(player.field_1600, player.field_1601, player.field_1602);
        }

        return class_26.method_1297(0, 0, 0);
    }

    @Override
    public Vector2f getRotation() {
        class_54 player = getPlayer();
        if (player != null) {
            return new Vector2f(player.field_1607, player.field_1606);
        }
        return new Vector2f(0f, 0f);
    }

    @Override
    public Set<PermissionNodeInstance<?>> getPermissions() {
        return UserPermissionManagerImpl.getNodes(getSourceName());
    }

    @Override
    public boolean satisfiesNode(PermissionNodeInstance<?> nodeToCheck) {
        if (server.field_2842.method_584(getSourceName())) {
            return true;
        }
        if (nodeToCheck == null) {
            return false;
        }
        return nodeToCheck.isSatisfiedBy(getPermissions());
    }

    @Override
    public class_57 getEntity() {
        return this.getPlayer();
    }

    @Nullable
    @Override
    public class_54 getPlayer() {
        return this.player;
    }

    @Override
    public @Nullable class_54 getPlayerByName(String playerName) {
        return server.field_2842.method_586(playerName);
    }

    @Override
    public List<class_54> getAllPlayers() {
        //noinspection unchecked
        return new ArrayList<class_54>(server.field_2842.field_578);
    }

    @Override
    public PlayerStorageFile getStorage() {
        //noinspection DataFlowIssue If you're null then something real bad happened.
        return PlayerStorageFile.of(getPlayer());
    }

    @Override
    public boolean isOp() {
        return server.field_2842.method_584(Objects.requireNonNull(getPlayer()).field_528);
    }
}
