package net.glasslauncher.glassbrigadier.mixin.server;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.glasslauncher.glassbrigadier.GlassBrigadier;
import net.glasslauncher.glassbrigadier.api.command.GlassCommandSource;
import net.minecraft.class_38;
import net.minecraft.class_426;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(class_426.class)
public class ServerCommandHandlerMixin {

    @ModifyVariable(method = "executeCommand", at = @At(value = "STORE", target = "Lnet/minecraft/server/command/Command;commandAndArgs:Ljava/lang/String;"))
    String sanitizeExecVanilla(String value) {
        if (value.startsWith("executevanilla ")) {
            return value.substring(15);
        }
        else if (value.startsWith("ev ")) {
            return value.substring(3);
        }
        return value;
    }

    @Inject(method = "executeCommand", at = @At(value = "HEAD"), cancellable = true)
    void hijackCommands(class_38 command, CallbackInfo ci) {
        if (command.field_159.startsWith("executevanilla ") || command.field_159.startsWith("ev ")) {
            return;
        }
        try {
            GlassBrigadier.dispatcher.execute(command.field_159, (GlassCommandSource) command.field_160);
        } catch (CommandSyntaxException e) {
            command.field_160.method_1409(e.getMessage());
        }
        ci.cancel();
    }

}
