package net.glasslauncher.mods.glassmappinglib.impl;

import net.fabricmc.loader.api.FabricLoader;
import net.glasslauncher.mods.glassmappinglib.api.DimensionWaypointData;
import net.glasslauncher.mods.glassmappinglib.api.Waypoint;
import net.glasslauncher.mods.glassmappinglib.api.event.WaypointsLoadedEvent;
import net.mine_diver.unsafeevents.listener.EventListener;
import net.minecraft.class_18;
import net.minecraft.client.Minecraft;
import net.modificationstation.stationapi.api.StationAPI;
import net.modificationstation.stationapi.api.event.mod.InitEvent;
import net.modificationstation.stationapi.api.event.world.WorldEvent;
import net.modificationstation.stationapi.api.mod.entrypoint.Entrypoint;
import net.modificationstation.stationapi.api.mod.entrypoint.EventBusPolicy;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.Namespace;
import net.modificationstation.stationapi.api.util.Null;
import net.modificationstation.stationapi.api.world.dimension.VanillaDimensions;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.simpleyaml.configuration.ConfigurationSection;
import org.simpleyaml.configuration.file.YamlFileWrapper;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@ApiStatus.Internal
@Entrypoint(eventBus = @EventBusPolicy(registerInstance = false))
public class GMLCore {
    @SuppressWarnings("UnstableApiUsage")
    public static final Namespace NAMESPACE = Namespace.resolve();

    public static final Logger LOGGER = NAMESPACE.getLogger("GlassMappingLib");

    private static Map<Identifier, DimensionWaypointData> waypointData;
    private static GMLYamlFile gmlYamlFile;

    public static void loadData(class_18 world) {
        if (world.field_180) {
            InetSocketAddress address =  (InetSocketAddress) Minecraft.field_2791.method_2145().field_1971.field_1282;
            String serverAddress = address.getHostName() + ":" + address.getPort();
            gmlYamlFile = new GMLYamlFile(new File(FabricLoader.getInstance().getConfigDir().toFile(), NAMESPACE + "/serverWaypoints/" + serverAddress.hashCode() + ".yaml"));
        }
        else {
            gmlYamlFile = new GMLYamlFile(new File(world.field_219.method_1736("dummy").getParentFile(), "waypoints.yaml"));
        }

        try {
            gmlYamlFile.createOrLoadWithComments();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }

        LOGGER.info("Loading waypoint data.");

        // Manually doing this cause the serialization documentation is ASS
        //noinspection unchecked
        Map<Identifier, DimensionWaypointData> data = ((List<ConfigurationSection>) gmlYamlFile.getList("waypoints", new ArrayList<>())).stream().map(e -> DimensionWaypointData.loadData(e.getMapValues(false))).collect(Collectors.toMap(DimensionWaypointData::dimensionId, dimensionWaypointData -> dimensionWaypointData));
        waypointData = data;

        StationAPI.EVENT_BUS.post(WaypointsLoadedEvent.builder().worldWaypointData(data).build());
    }

    public static boolean addWaypoint(Waypoint waypoint) {
        DimensionWaypointData data = waypointData.computeIfAbsent(waypoint.dimension, key -> new DimensionWaypointData(key, new ArrayList<>()));
        data.waypoints().add(waypoint);
        return true;
    }

    public static boolean removeWaypoint(Waypoint waypoint) {
        DimensionWaypointData data = waypointData.get(waypoint.dimension);
        if (data == null) {
            return false;
        }

        return data.waypoints().remove(waypoint);
    }

    public static DimensionWaypointData getWaypoints(Identifier dimensionId) {
        return waypointData.computeIfAbsent(dimensionId, key -> new DimensionWaypointData(key, new ArrayList<>()));
    }

    public static void clearWaypoints() {
        saveData(null);
        waypointData = null;
    }

    @EventListener
    public static void saveData(WorldEvent.Save event) {
        if (waypointData == null) {
            return;
        }

        gmlYamlFile = new GMLYamlFile(gmlYamlFile.getConfigurationFile());
        YamlFileWrapper waypointsPath = gmlYamlFile.path("waypoints");

        waypointData.forEach((identifier, dimensionWaypointData) -> waypointsPath.path(identifier.toString()).set(dimensionWaypointData.serialize()));

        try {
            gmlYamlFile.save();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
