package net.glasslauncher.mods.glassmappinglib.mixin.client;

import com.llamalad7.mixinextras.sugar.Local;
import net.glasslauncher.mods.glassmappinglib.impl.GMLCore;
import net.minecraft.class_18;
import net.minecraft.class_54;
import net.minecraft.client.Minecraft;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(Minecraft.class)
class MinecraftMixin {

    @Shadow public class_18 world;

    @Inject(method = "startGame", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/Minecraft;setWorld(Lnet/minecraft/world/World;Ljava/lang/String;)V"))
    private void init(String name, String seed, long par3, CallbackInfo ci, @Local class_18 world) {
        GMLCore.loadData(world);
    }

    @Inject(method = "setWorld(Lnet/minecraft/world/World;Ljava/lang/String;Lnet/minecraft/entity/player/PlayerEntity;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/World;savingProgress(Lnet/minecraft/client/gui/screen/LoadingDisplay;)V", shift = At.Shift.AFTER))
    private void clearWorldData(class_18 message, String player, class_54 par3, CallbackInfo ci) {
        if (world != null) {
            GMLCore.clearWaypoints();
        }
    }
}
