package net.glasslauncher.mods.glassmappinglib.api;

import net.modificationstation.stationapi.api.util.Identifier;
import org.simpleyaml.configuration.ConfigurationSection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public record DimensionWaypointData(Identifier dimensionId, List<Waypoint> waypoints) {

    public Map<String, Object> serialize() {
        Map<String, Object> map = new HashMap<>();

        map.put("dimensionId", dimensionId.toString());
        map.put("waypoints", waypoints.stream().map(Waypoint::serialize).toArray());
        return map;
    }

    public static DimensionWaypointData loadData(Map<String, Object> map) {
        Identifier dimensionId = Identifier.of((String) map.get("dimensionId"));
        //noinspection unchecked
        return new DimensionWaypointData(
                dimensionId,
                new ArrayList<>(((List<Map<String, Object>>) map.get("waypoints")).stream().map(entry -> Waypoint.loadData(entry, dimensionId)).toList())
                );
    }
}
