package net.glasslauncher.mods.glassmappinglib.api;

import lombok.AllArgsConstructor;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.math.ColorHelper;
import org.jetbrains.annotations.NotNull;

import javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/**
 * This is strictly a data storage object. Contains all waypoint-specific information.
 */
public class Waypoint {
    public int x;
    public int y;
    public int z;
    public @NotNull String name;

    /**
     * The dimension this waypoint belongs to.
     */
    public @NotNull Identifier dimension;

    /**
     * The resource identifier for the waypoint icon, if any.
     */
    public @Nullable Identifier icon;
    /**
     * Minecraft color integer for the icon colour.
     * @see ColorHelper.Argb#getArgb(int, int, int, int)
     */
    public @Nullable Integer color;

    public boolean visibleInWorld = true;
    public boolean visibleInMap = true;
    public boolean visibleInMiniMap = true;

    public Waypoint(@NotNull Identifier dimension, int x, int y, int z, @NotNull String name) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.name = name;
        this.dimension = dimension;
    }

    public Waypoint(@NotNull Identifier dimension, int x, int y, int z, @NotNull String name, @Nullable Identifier icon, @Nullable Integer color) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.name = name;
        this.dimension = dimension;
        this.icon = icon;
        this.color = color;
    }

    public Waypoint(@NotNull Identifier dimension, int x, int y, int z, @NotNull String name, @Nullable Identifier icon, @Nullable Integer color, boolean visibleInWorld, boolean visibleInMap, boolean visibleInMiniMap) {
        this.dimension = dimension;
        this.x = x;
        this.y = y;
        this.z = z;
        this.name = name;
        this.icon = icon;
        this.color = color;
        this.visibleInWorld = visibleInWorld;
        this.visibleInMap = visibleInMap;
        this.visibleInMiniMap = visibleInMiniMap;
    }

    public Map<String, Object> serialize() {
        Map<String, Object> map = new HashMap<>();

        map.put("x", x);
        map.put("y", y);
        map.put("z", z);
        map.put("name", name);
        map.put("icon", icon != null ? icon.toString() : null);
        map.put("color", color);
        map.put("visibleInMap", visibleInMap);
        map.put("visibleInMiniMap", visibleInMiniMap);
        map.put("visibleInWorld", visibleInWorld);

        return map;
    }

    public static Waypoint loadData(Map<String, Object> map, Identifier dimension) {
        return new Waypoint(
                dimension,
                (Integer) map.get("x"),
                (Integer) map.get("y"),
                (Integer) map.get("z"),
                (String) map.get("name"),
                map.get("icon") == null ? null : Identifier.of((String) map.get("icon")),
                (Integer) map.get("color"),
                (Boolean) map.get("visibleInMap"),
                (Boolean) map.get("visibleInMiniMap"),
                (Boolean) map.get("visibleInWorld")
        );
    }
}
