package net.glasslauncher.mods.glassmappinglib.impl;

import org.simpleyaml.configuration.comments.format.YamlCommentFormat;
import org.simpleyaml.configuration.file.YamlFile;
import org.simpleyaml.configuration.implementation.SimpleYamlImplementation;
import org.simpleyaml.configuration.implementation.api.QuoteStyle;
import org.simpleyaml.configuration.implementation.snakeyaml.lib.DumperOptions;
import org.simpleyaml.configuration.implementation.snakeyaml.lib.LoaderOptions;

import java.io.File;
import java.util.List;
import java.util.Map;

public class GMLYamlFile extends YamlFile {

    public GMLYamlFile(File file) throws IllegalArgumentException {
        super(file);
        this.addDefault("schemaVersion", 1);
        this.options().useComments(true);
        this.setCommentFormat(YamlCommentFormat.PRETTY);
        this.options().headerFormatter().prefixFirst("###############################################################").commentPrefix("##  ").commentSuffix("  ##").suffixLast("###############################################################");
        this.setHeader("CONFIG GENERATED BY GLASS MAPPING LIB (GML).           \nDO NOT EDIT UNLESS YOU'RE FINE RISKING DATA CORRUPTION.\nUSE AN IN-GAME EDITOR WHERE POSSIBLE.                  ");
    }
}
