package net.glasslauncher.mods.glassmappinglib.mixin.server;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.glasslauncher.mods.glassmappinglib.api.GlassMappingLib;
import net.glasslauncher.mods.glassmappinglib.impl.GMLCore;
import net.minecraft.class_73;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(MinecraftServer.class)
public class MinecraftServerMixin {

    @Shadow public class_73[] worlds;

    @WrapOperation(method = "loadWorld", at = @At(value = "INVOKE", target = "Ljava/lang/System;currentTimeMillis()J", ordinal = 0))
    private long init(Operation<Long> original) {
        GMLCore.loadData(worlds[0]);
        return original.call();
    }
}
