/*
 * Decompiled with CFR 0.152.
 */
package io.github.prospector.modmenu.config;

import io.github.prospector.modmenu.config.ModMenuConfigManager;
import io.github.prospector.modmenu.util.HardcodedUtil;
import java.util.Comparator;
import java.util.Properties;
import net.fabricmc.loader.api.ModContainer;

public class ModMenuConfig {
    private boolean showLibraries = false;
    private Sorting sorting = Sorting.ASCENDING;

    public void toggleShowLibraries() {
        this.showLibraries = !this.showLibraries;
        ModMenuConfigManager.save();
    }

    public void toggleSortMode() {
        this.sorting = Sorting.values()[(this.sorting.ordinal() + 1) % Sorting.values().length];
        ModMenuConfigManager.save();
    }

    public boolean showLibraries() {
        return this.showLibraries;
    }

    public Properties serialize() {
        Properties properties = new Properties();
        properties.put("showLibraries", this.showLibraries ? "true" : "false");
        properties.put("sorting", this.sorting.name());
        return properties;
    }

    public void deserialize(Properties properties) {
        this.showLibraries = properties.getOrDefault((Object)"showLibraries", "false").equals("true");
        this.sorting = Sorting.valueOf((String)properties.getOrDefault((Object)"sorting", "ASCENDING"));
    }

    public Sorting getSorting() {
        return this.sorting;
    }

    public static enum Sorting {
        ASCENDING(Comparator.comparing(modContainer -> HardcodedUtil.formatFabricModuleName(modContainer.getMetadata().getName())), "A-Z"),
        DECENDING(ASCENDING.getComparator().reversed(), "Z-A");

        final Comparator<ModContainer> comparator;
        final String name;

        private Sorting(Comparator<ModContainer> comparator, String name) {
            this.comparator = comparator;
            this.name = name;
        }

        public Comparator<ModContainer> getComparator() {
            return this.comparator;
        }

        public String getName() {
            return this.name;
        }
    }
}

