package io.github.prospector.modmenu.gui;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_189;
import net.minecraft.class_32;
import net.minecraft.class_67;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

@Environment(EnvType.CLIENT)
public abstract class EntryListWidget<E extends EntryListWidget.Entry<E>> extends class_32 {
	protected static final int DRAG_OUTSIDE = -2;
	protected final Minecraft field_151;
	protected final int itemHeight;
	private final List<E> children = new EntryListWidget.Entries();
	protected int field_152;
	protected int field_153;
	protected int top;
	protected int bottom;
	protected int right;
	protected int left;
	protected boolean centerListVertically = true;
	protected int yDrag = -2;
	private double scrollAmount;
	protected boolean renderSelection = true;
	protected boolean renderHeader;
	protected int headerHeight;
	private boolean scrolling;
	private E selected;

	private E focused;
	private boolean dragging;

	public EntryListWidget(Minecraft minecraftClient, int i, int j, int k, int l, int m) {
		this.field_151 = minecraftClient;
		this.field_152 = i;
		this.field_153 = j;
		this.top = k;
		this.bottom = l;
		this.itemHeight = m;
		this.left = 0;
		this.right = i;
	}

	public void setRenderSelection(boolean bl) {
		this.renderSelection = bl;
	}

	protected void setRenderHeader(boolean bl, int i) {
		this.renderHeader = bl;
		this.headerHeight = i;
		if (!bl) {
			this.headerHeight = 0;
		}

	}

	public int getRowWidth() {
		return 220;
	}

	@Nullable
	public E getSelected() {
		return this.selected;
	}

	public void setSelected(@Nullable E entry) {
		this.selected = entry;
	}

	@Nullable
	public E getFocused() {
		return focused;
	}

	public void setFocused(E focused) {
		this.focused = focused;
	}

	public void setDragging(boolean dragging) {
		this.dragging = dragging;
	}

	public final List<E> children() {
		return this.children;
	}

	protected final void clearEntries() {
		this.children.clear();
	}

	protected void replaceEntries(Collection<E> collection) {
		this.children.clear();
		this.children.addAll(collection);
	}

	protected E getEntry(int i) {
		return this.children().get(i);
	}

	protected int addEntry(E entry) {
		this.children.add(entry);
		return this.children.size() - 1;
	}

	protected int getItemCount() {
		return this.children().size();
	}

	protected boolean isSelectedItem(int i) {
		return Objects.equals(this.getSelected(), this.children().get(i));
	}

	@Nullable
	protected final E getEntryAtPosition(double d, double e) {
		int i = this.getRowWidth() / 2;
		int j = this.left + this.field_152 / 2;
		int k = j - i;
		int l = j + i;
		int m = class_189.method_645(e - (double)this.top) - this.headerHeight + (int)this.getScrollAmount() - 4; // convertToBlockCoord
		int n = m / this.itemHeight;
		return d < (double)this.getScrollbarPosition() && d >= (double)k && d <= (double)l && n >= 0 && m >= 0 && n < this.getItemCount() ? this.children().get(n) : null;
	}

	public void updateSize(int i, int j, int k, int l) {
		this.field_152 = i;
		this.field_153 = j;
		this.top = k;
		this.bottom = l;
		this.left = 0;
		this.right = i;
	}

	public void setLeftPos(int i) {
		this.left = i;
		this.right = i + this.field_152;
	}

	protected int getMaxPosition() {
		return this.getItemCount() * this.itemHeight + this.headerHeight;
	}

	protected void clickedHeader(int i, int j) {
	}

	protected void renderHeader(int i, int j, class_67 tessellator) {
	}


	public void method_134() {
	}

	protected void renderDecorations(int i, int j) {
	}

	public void method_118(int i, int j, float f) {
		oldY = j;
		this.method_134();
		int k = this.getScrollbarPosition();
		int l = k + 6;
		class_67 tessellator = class_67.field_2054;
		this.field_151.field_2814.method_1097(this.field_151.field_2814.method_1100("/gui/background.png"));
		GL11.glColor4f(1f, 1f, 1f, 1f);
		float g = 32.0F;
		tessellator.method_1695();
		tessellator.method_1693(32, 32, 32);
		tessellator.method_1688(this.left, this.bottom, 0.0D, (float)this.left / 32.0F, (float)(this.bottom + (int)this.getScrollAmount()) / 32.0F);
		tessellator.method_1688(this.right, this.bottom, 0.0D, (float)this.right / 32.0F, (float)(this.bottom + (int)this.getScrollAmount()) / 32.0F);
		tessellator.method_1688(this.right, this.top, 0.0D, (float)this.right / 32.0F, (float)(this.top + (int)this.getScrollAmount()) / 32.0F);
		tessellator.method_1688(this.left, this.top, 0.0D, (float)this.left / 32.0F, (float)(this.top + (int)this.getScrollAmount()) / 32.0F);
		tessellator.method_1685();
		int m = this.getRowLeft();
		int n = this.top + 4 - (int)this.getScrollAmount();
		if (this.renderHeader) {
			this.renderHeader(m, n, tessellator);
		}

		this.renderList(m, n, i, j, f);
		GL11.glDisable(GL11.GL_DEPTH_TEST);
		this.renderHoleBackground(0, this.top, 255, 255);
		this.renderHoleBackground(this.bottom, this.field_153, 255, 255);
		GL11.glEnable(GL11.GL_BLEND);
		GL14.glBlendFuncSeparate(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA, GL11.GL_ZERO, GL11.GL_ONE);
		GL11.glDisable(GL11.GL_ALPHA_TEST);
		GL11.glShadeModel(GL11.GL_SMOOTH);
		GL11.glDisable(GL11.GL_TEXTURE_2D);
		boolean o = true;
		tessellator.method_1695();
		tessellator.method_1694(0, 0, 0, 0);
		tessellator.method_1688(this.left, this.top + 4, 0.0D, 0.0F, 1.0F);
		tessellator.method_1688(this.right, this.top + 4, 0.0D, 1.0F, 1.0F);
		tessellator.method_1693(0, 0, 0);
		tessellator.method_1688(this.right, this.top, 0.0D, 1.0F, 0.0F);
		tessellator.method_1688(this.left, this.top, 0.0D, 0.0F, 0.0F);
		tessellator.method_1685();
		tessellator.method_1695();
		tessellator.method_1693(0, 0, 0);
		tessellator.method_1688(this.left, this.bottom, 0.0D, 0.0F, 1.0F);
		tessellator.method_1688(this.right, this.bottom, 0.0D, 1.0F, 1.0F);
		tessellator.method_1694(0, 0, 0, 0);
		tessellator.method_1688(this.right, this.bottom - 4, 0.0D, 1.0F, 0.0F);
		tessellator.method_1688(this.left, this.bottom - 4, 0.0D, 0.0F, 0.0F);
		tessellator.method_1685();
		int p = this.getMaxScroll();
		if (p > 0) {
			int q = (int)((float)((this.bottom - this.top) * (this.bottom - this.top)) / (float)this.getMaxPosition());
			if (q < 32)
				q = 32;
			else if (q > this.bottom - this.top - 8)
				q = this.bottom - this.top - 8;
			int r = (int)this.getScrollAmount() * (this.bottom - this.top - q) / p + this.top;
			if (r < this.top) {
				r = this.top;
			}

			tessellator.method_1695();
			tessellator.method_1693(0, 0, 0);
			tessellator.method_1688(k, this.bottom, 0.0D, 0.0F, 1.0F);
			tessellator.method_1688(l, this.bottom, 0.0D, 1.0F, 1.0F);
			tessellator.method_1688(l, this.top, 0.0D, 1.0F, 0.0F);
			tessellator.method_1688(k, this.top, 0.0D, 0.0F, 0.0F);
			tessellator.method_1685();
			tessellator.method_1695();
			tessellator.method_1693(128, 128, 128);
			tessellator.method_1688(k, r + q, 0.0D, 0.0F, 1.0F);
			tessellator.method_1688(l, r + q, 0.0D, 1.0F, 1.0F);
			tessellator.method_1688(l, r, 0.0D, 1.0F, 0.0F);
			tessellator.method_1688(k, r, 0.0D, 0.0F, 0.0F);
			tessellator.method_1685();
			tessellator.method_1695();
			tessellator.method_1693(192, 192, 192);
			tessellator.method_1688(k, r + q - 1, 0.0D, 0.0F, 1.0F);
			tessellator.method_1688(l - 1, r + q - 1, 0.0D, 1.0F, 1.0F);
			tessellator.method_1688(l - 1, r, 0.0D, 1.0F, 0.0F);
			tessellator.method_1688(k, r, 0.0D, 0.0F, 0.0F);
			tessellator.method_1685();
		}

		this.renderDecorations(i, j);
		GL11.glEnable(GL11.GL_TEXTURE_2D);
		GL11.glShadeModel(GL11.GL_FLAT);
		GL11.glEnable(GL11.GL_ALPHA_TEST);
		GL11.glDisable(GL11.GL_BLEND);
		GL11.glEnable(GL11.GL_DEPTH_TEST);
	}

	protected void centerScrollOn(E entry) {
		this.setScrollAmount(this.children().indexOf(entry) * this.itemHeight + this.itemHeight / 2 - (this.bottom - this.top) / 2);
	}

	protected void ensureVisible(E entry) {
		int i = this.getRowTop(this.children().indexOf(entry));
		int j = i - this.top - 4 - this.itemHeight;
		if (j < 0) {
			this.scroll(j);
		}

		int k = this.bottom - i - this.itemHeight - this.itemHeight;
		if (k < 0) {
			this.scroll(-k);
		}

	}

	private void scroll(int i) {
		this.setScrollAmount(this.getScrollAmount() + (double)i);
		this.yDrag = -2;
	}

	public double getScrollAmount() {
		return this.scrollAmount;
	}

	public void setScrollAmount(double d) {
		if (d < 0)
			d = 0;
		if (d > getMaxScroll())
			d = getMaxScroll();
		this.scrollAmount = d;
	}

	private int getMaxScroll() {
		return Math.max(0, this.getMaxPosition() - (this.bottom - this.top - 4));
	}

	public int getScrollBottom() {
		return (int)this.getScrollAmount() - this.field_153 - this.headerHeight;
	}

	protected void updateScrollingState(double d, double e, int i) {
		this.scrolling = i == 0 && d >= (double)this.getScrollbarPosition() && d < (double)(this.getScrollbarPosition() + 6);
	}

	protected int getScrollbarPosition() {
		return this.field_152 / 2 + 124;
	}

	public boolean mouseClicked(double d, double e, int i) {
		this.updateScrollingState(d, e, i);
		if (!this.isMouseOver(d, e)) {
			return false;
		} else {
			E entry = this.getEntryAtPosition(d, e);
			if (entry != null) {
				if (entry.mouseClicked(d, e, i)) {
					this.focused = entry;
					this.dragging = true;
					return true;
				}
			} else if (i == 0) {
				this.clickedHeader((int)(d - (double)(this.left + this.field_152 / 2 - this.getRowWidth() / 2)), (int)(e - (double)this.top) + (int)this.getScrollAmount() - 4);
				return true;
			}

			return this.scrolling;
		}
	}

	public boolean mouseReleased(double d, double e, int i) {
		if (this.getFocused() != null) {
			this.getFocused().mouseReleased(d, e, i);
		}

		return false;
	}

	double oldY = -1;
	public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double mouseDX, double mouseDY) {
		if (mouseButton == 0 && isMouseOver(mouseX, mouseY)) {
			setScrollAmount(getScrollAmount() - mouseY + oldY);
			return true;
		} else {
			return false;
		}
	}

	public boolean mouseScrolled(double d, double e, double f) {
		this.setScrollAmount(this.getScrollAmount() - f * (double)this.itemHeight / 2.0D);
		return true;
	}

	public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
		if (this.getFocused() != null && this.getFocused().keyPressed(keyCode, scanCode, modifiers)) {
			return true;
		} else if (keyCode == 264) {
			this.moveSelection(1);
			return true;
		} else if (keyCode == 265) {
			this.moveSelection(-1);
			return true;
		} else {
			return false;
		}
	}

	protected void moveSelection(int i) {
		if (!this.children().isEmpty()) {
			int j = this.children().indexOf(this.getSelected());
			int k = j + i;
			if (k < 0)
				k = 0;
			else if (k > getItemCount() - 1)
				k = getItemCount() - 1;
			E entry = this.children().get(k);
			this.setSelected(entry);
			this.ensureVisible(entry);
		}

	}

	public boolean isMouseOver(double d, double e) {
		return e >= (double)this.top && e <= (double)this.bottom && d >= (double)this.left && d <= (double)this.right;
	}

	protected void renderList(int i, int j, int k, int l, float f) {
		int m = this.getItemCount();
		class_67 tessellator = class_67.field_2054;

		for(int n = 0; n < m; ++n) {
			int o = this.getRowTop(n);
			int p = this.getRowBottom(n);
			if (p >= this.top && o <= this.bottom) {
				int q = j + n * this.itemHeight + this.headerHeight;
				int r = this.itemHeight - 4;
				E entry = this.getEntry(n);
				int s = this.getRowWidth();
				int v;
				if (this.renderSelection && this.isSelectedItem(n)) {
					v = this.left + this.field_152 / 2 - s / 2;
					int u = this.left + this.field_152 / 2 + s / 2;
					GL11.glDisable(GL11.GL_TEXTURE_2D);
					float g = this.isFocused() ? 1.0F : 0.5F;
					GL11.glColor4f(g, g, g, 1f);
					tessellator.method_1695();
					tessellator.method_1687(v, q + r + 2, 0.0D);
					tessellator.method_1687(u, q + r + 2, 0.0D);
					tessellator.method_1687(u, q - 2, 0.0D);
					tessellator.method_1687(v, q - 2, 0.0D);
					tessellator.method_1685();
					GL11.glColor4f(0f, 0f, 0f, 1f);
					tessellator.method_1695();
					tessellator.method_1687(v + 1, q + r + 1, 0.0D);
					tessellator.method_1687(u - 1, q + r + 1, 0.0D);
					tessellator.method_1687(u - 1, q - 1, 0.0D);
					tessellator.method_1687(v + 1, q - 1, 0.0D);
					tessellator.method_1685();
					GL11.glEnable(GL11.GL_TEXTURE_2D);
				}

				v = this.getRowLeft();
				entry.render(n, o, v, s, r, k, l, this.isMouseOver(k, l) && Objects.equals(this.getEntryAtPosition(k, l), entry), f);
			}
		}

	}

	protected int getRowLeft() {
		return this.left + this.field_152 / 2 - this.getRowWidth() / 2 + 2;
	}

	protected int getRowTop(int i) {
		return this.top + 4 - (int)this.getScrollAmount() + i * this.itemHeight + this.headerHeight;
	}

	private int getRowBottom(int i) {
		return this.getRowTop(i) + this.itemHeight;
	}

	protected boolean isFocused() {
		return false;
	}

	protected void renderHoleBackground(int i, int j, int k, int l) {
		class_67 tessellator = class_67.field_2054;
		this.field_151.field_2814.method_1097(this.field_151.field_2814.method_1100("/gui/background.png"));
		GL11.glColor4f(1f, 1f, 1f, 1f);
		float f = 32.0F;
		tessellator.method_1695();
		tessellator.method_1694(64, 64, 64, l);
		tessellator.method_1688(this.left, j, 0.0D, 0.0F, (float)j / 32.0F);
		tessellator.method_1688(this.left + this.field_152, j, 0.0D, (float)this.field_152 / 32.0F, (float)j / 32.0F);
		tessellator.method_1694(64, 64, 64, k);
		tessellator.method_1688(this.left + this.field_152, i, 0.0D, (float)this.field_152 / 32.0F, (float)i / 32.0F);
		tessellator.method_1688(this.left, i, 0.0D, 0.0F, (float)i / 32.0F);
		tessellator.method_1685();
	}

	protected E remove(int i) {
		E entry = this.children.get(i);
		return this.removeEntry(this.children.get(i)) ? entry : null;
	}

	protected boolean removeEntry(E entry) {
		boolean bl = this.children.remove(entry);
		if (bl && entry == this.getSelected()) {
			this.setSelected(null);
		}

		return bl;
	}

	@Environment(EnvType.CLIENT)
	class Entries extends AbstractList<E> {
		private final List<E> entries;

		private Entries() {
			this.entries = new ArrayList<>();
		}

		public E get(int i) {
			return this.entries.get(i);
		}

		public int size() {
			return this.entries.size();
		}

		public E set(int i, E entry) {
			E entry2 = this.entries.set(i, entry);
			entry.list = EntryListWidget.this;
			return entry2;
		}

		public void add(int i, E entry) {
			this.entries.add(i, entry);
			entry.list = EntryListWidget.this;
		}

		public E remove(int i) {
			return this.entries.remove(i);
		}
	}

	@Environment(EnvType.CLIENT)
	public abstract static class Entry<E extends EntryListWidget.Entry<E>> extends class_32 {
		@Deprecated
		EntryListWidget<E> list;

		public Entry() {
		}

		public abstract void render(int i, int j, int k, int l, int m, int n, int o, boolean bl, float f);

		public boolean isMouseOver(double d, double e) {
			return Objects.equals(this.list.getEntryAtPosition(d, e), this);
		}

		public void mouseMoved(double d, double e) {
		}

		public boolean mouseClicked(double d, double e, int i) {
			return false;
		}

		public boolean mouseReleased(double d, double e, int i) {
			return false;
		}

		public boolean mouseScrolled(double d, double e, double f) {
			return false;
		}

		public boolean keyPressed(int i, int j, int k) {
			return false;
		}

		public boolean keyReleased(int i, int j, int k) {
			return false;
		}

		public boolean charTyped(char c, int i) {
			return false;
		}

		public boolean changeFocus(boolean bl) {
			return false;
		}

	}
}
