/*
 * Decompiled with CFR 0.152.
 */
package io.github.prospector.modmenu.config;

import io.github.prospector.modmenu.config.ModMenuConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;

public class ModMenuConfigManager {
    private static File file;
    private static ModMenuConfig config;

    private static void prepareConfigFile() {
        if (file != null) {
            return;
        }
        file = new File(FabricLoader.getInstance().getConfigDir().toFile(), "modmenu.properties");
    }

    public static void initializeConfig() {
        if (config != null) {
            return;
        }
        config = new ModMenuConfig();
        ModMenuConfigManager.load();
    }

    private static void load() {
        ModMenuConfigManager.prepareConfigFile();
        try {
            if (!file.exists()) {
                ModMenuConfigManager.save();
            }
            if (file.exists()) {
                BufferedReader br = new BufferedReader(new FileReader(file));
                Properties modProps = new Properties();
                modProps.load(br);
                config = new ModMenuConfig();
                config.deserialize(modProps);
            }
        }
        catch (IOException e) {
            System.err.println("Couldn't load Mod Menu configuration file; reverting to defaults");
            e.printStackTrace();
        }
    }

    public static void save() {
        ModMenuConfigManager.prepareConfigFile();
        try (FileWriter fileWriter = new FileWriter(file);){
            config.serialize().store(fileWriter, "ModMenu Config");
        }
        catch (IOException e) {
            System.err.println("Couldn't save Mod Menu configuration file");
            e.printStackTrace();
        }
    }

    public static ModMenuConfig getConfig() {
        return config;
    }
}

