/*
 * Decompiled with CFR 0.152.
 */
package io.github.prospector.modmenu.util;

import io.github.prospector.modmenu.ModMenu;
import io.github.prospector.modmenu.gui.ModListScreen;
import io.github.prospector.modmenu.util.HardcodedUtil;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;

public class ModListSearch {
    public static boolean validSearchQuery(String query) {
        return query != null && !query.isEmpty();
    }

    public static List<ModContainer> search(ModListScreen screen, String query, List<ModContainer> candidates) {
        if (!ModListSearch.validSearchQuery(query)) {
            return candidates;
        }
        return candidates.stream().filter(modContainer -> ModListSearch.passesFilters(screen, modContainer, query.toLowerCase(Locale.ROOT))).collect(Collectors.toList());
    }

    private static boolean passesFilters(ModListScreen screen, ModContainer container, String query) {
        ModMetadata metadata = container.getMetadata();
        String modId = metadata.getId();
        if (HardcodedUtil.formatFabricModuleName(metadata.getName()).toLowerCase(Locale.ROOT).contains(query) || modId.toLowerCase(Locale.ROOT).contains(query) || ModListSearch.authorMatches(container, query) || ModMenu.LIBRARY_MODS.contains(modId) && "api library".contains(query) || "clientside".contains(query) && ModMenu.CLIENTSIDE_MODS.contains(modId) || "configurations configs configures configurable".contains(query) && ModMenu.hasConfigScreenFactory(modId)) {
            return true;
        }
        if (ModMenu.PARENT_MAP.keySet().contains(container)) {
            for (ModContainer child : ModMenu.PARENT_MAP.get((Object)container)) {
                if (!ModListSearch.passesFilters(screen, child, query)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean authorMatches(ModContainer modContainer, String query) {
        return modContainer.getMetadata().getAuthors().stream().filter(Objects::nonNull).map(Person::getName).filter(Objects::nonNull).map(s -> s.toLowerCase(Locale.ROOT)).anyMatch(s -> s.contains(query.toLowerCase(Locale.ROOT)));
    }
}

