/*
 * Decompiled with CFR 0.152.
 */
package io.github.prospector.modmenu;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedListMultimap;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.prospector.modmenu.api.ModMenuApi;
import io.github.prospector.modmenu.config.ModMenuConfigManager;
import io.github.prospector.modmenu.util.HardcodedUtil;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_285;
import net.minecraft.class_32;
import net.minecraft.class_635;
import net.minecraft.client.Minecraft;

public class ModMenu
implements ClientModInitializer {
    public static final String MOD_ID = "modmenu";
    public static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();
    private static final Map<String, Runnable> LEGACY_CONFIG_SCREEN_TASKS = new HashMap<String, Runnable>();
    public static final List<String> LIBRARY_MODS = new ArrayList<String>();
    public static final Set<String> CLIENTSIDE_MODS = new HashSet<String>();
    public static final Set<String> PATCHWORK_FORGE_MODS = new HashSet<String>();
    public static final LinkedListMultimap<ModContainer, ModContainer> PARENT_MAP = LinkedListMultimap.create();
    private static ImmutableMap<String, Function<class_32, ? extends class_32>> configScreenFactories = ImmutableMap.of();
    private static int libraryCount = 0;
    public static class_285 currentTexturePack;

    public static boolean hasConfigScreenFactory(String modid) {
        return configScreenFactories.containsKey((Object)modid);
    }

    public static class_32 getConfigScreen(String modid, class_32 menuScreen) {
        Function factory = (Function)configScreenFactories.get((Object)modid);
        return factory != null ? (class_32)factory.apply(menuScreen) : null;
    }

    public static void openConfigScreen(String modid) {
        Runnable opener = LEGACY_CONFIG_SCREEN_TASKS.get(modid);
        if (opener != null) {
            opener.run();
        }
    }

    public static void addLegacyConfigScreenTask(String modid, Runnable task) {
        LEGACY_CONFIG_SCREEN_TASKS.putIfAbsent(modid, task);
    }

    public static boolean hasLegacyConfigScreenTask(String modid) {
        return LEGACY_CONFIG_SCREEN_TASKS.containsKey(modid);
    }

    public static void addLibraryMod(String modid) {
        if (LIBRARY_MODS.contains(modid)) {
            return;
        }
        LIBRARY_MODS.add(modid);
    }

    public void onInitializeClient() {
        ModMenuConfigManager.initializeConfig();
        ImmutableMap.Builder factories = ImmutableMap.builder();
        FabricLoader.getInstance().getEntrypoints(MOD_ID, ModMenuApi.class).forEach(api -> factories.put((Object)api.getModId(), api.getConfigScreenFactory()));
        factories.put((Object)"minecraft", screenBase -> new class_635(screenBase, ((Minecraft)FabricLoader.getInstance().getGameInstance()).field_2824));
        configScreenFactories = factories.build();
        Collection mods = FabricLoader.getInstance().getAllMods();
        HardcodedUtil.initializeHardcodings();
        for (ModContainer mod : mods) {
            CustomValue.CvObject object;
            ModMetadata metadata = mod.getMetadata();
            String id = metadata.getId();
            if (metadata.containsCustomValue("modmenu:api") && metadata.getCustomValue("modmenu:api").getAsBoolean()) {
                ModMenu.addLibraryMod(id);
            }
            if (!id.equals("minecraft") && metadata.getType().equals("builtin")) {
                ModMenu.addLibraryMod(id);
            }
            for (ModContainer containedMod : mod.getContainedMods()) {
                if (metadata.containsCustomValue("modmenu:showIfContained") && metadata.getCustomValue("modmenu:showIfContained").getAsBoolean()) continue;
                ModMenu.addLibraryMod(containedMod.getMetadata().getId());
            }
            if (metadata.containsCustomValue("modmenu:clientsideOnly") && metadata.getCustomValue("modmenu:clientsideOnly").getAsBoolean()) {
                CLIENTSIDE_MODS.add(id);
            }
            if (metadata.containsCustomValue("patchwork:source") && metadata.getCustomValue("patchwork:source").getAsObject() != null && "forge".equals((object = metadata.getCustomValue("patchwork:source").getAsObject()).get("loader").getAsString())) {
                PATCHWORK_FORGE_MODS.add(id);
            }
            if (metadata.containsCustomValue("modmenu:parent")) {
                String parentId = metadata.getCustomValue("modmenu:parent").getAsString();
                if (parentId == null) continue;
                Optional parent = FabricLoader.getInstance().getModContainer(parentId);
                parent.ifPresent(modContainer -> PARENT_MAP.put(modContainer, (Object)mod));
                continue;
            }
            HardcodedUtil.hardcodeModuleMetadata(mod, metadata, id);
        }
        libraryCount = LIBRARY_MODS.size();
    }

    public static String getFormattedModCount() {
        return NumberFormat.getInstance().format(FabricLoader.getInstance().getAllMods().size());
    }
}

