/*
 * Decompiled with CFR 0.152.
 */
package io.github.prospector.modmenu.gui;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import io.github.prospector.modmenu.ModMenu;
import io.github.prospector.modmenu.config.ModMenuConfigManager;
import io.github.prospector.modmenu.gui.DescriptionListWidget;
import io.github.prospector.modmenu.gui.GuiButtonAccessor;
import io.github.prospector.modmenu.gui.ModListEntry;
import io.github.prospector.modmenu.gui.ModListWidget;
import io.github.prospector.modmenu.gui.ModMenuTexturedButtonWidget;
import io.github.prospector.modmenu.gui.TextFieldWidget;
import io.github.prospector.modmenu.util.BadgeRenderer;
import io.github.prospector.modmenu.util.HardcodedUtil;
import io.github.prospector.modmenu.util.RenderUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.class_32;
import net.minecraft.class_33;
import net.minecraft.class_34;
import net.minecraft.class_67;
import net.minecraft.client.Minecraft;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.Sys;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

public class ModListScreen
extends class_32 {
    private static final String FILTERS_BUTTON_LOCATION = "/assets/modmenu/textures/gui/filters_button.png";
    private static final String CONFIGURE_BUTTON_LOCATION = "/assets/modmenu/textures/gui/configure_button.png";
    private static final Logger LOGGER = LogManager.getLogger();
    private final String textTitle;
    private TextFieldWidget searchBox;
    private DescriptionListWidget descriptionListWidget;
    private class_32 parent;
    private ModListWidget modList;
    private String tooltip;
    private ModListEntry selected;
    private BadgeRenderer badgeRenderer;
    private double scrollPercent = 0.0;
    private boolean showModCount = false;
    private boolean init = false;
    private boolean filterOptionsShown = false;
    private int paneY;
    private int paneWidth;
    private int rightPaneX;
    private int searchBoxX;
    public Set<String> showModChildren = new HashSet<String>();
    private String lastSearchString = null;
    private static final int CONFIGURE_BUTTON_ID = 0;
    private static final int WEBSITE_BUTTON_ID = 1;
    private static final int ISSUES_BUTTON_ID = 2;
    private static final int TOGGLE_FILTER_OPTIONS_BUTTON_ID = 3;
    private static final int TOGGLE_SORT_MODE_BUTTON_ID = 4;
    private static final int TOGGLE_SHOW_LIBRARIES_BUTTON_ID = 5;
    private static final int MODS_FOLDER_BUTTON_ID = 6;
    private static final int DONE_BUTTON_ID = 7;

    public ModListScreen(class_32 previousGui) {
        this.parent = previousGui;
        this.textTitle = "Mods";
    }

    public void method_131() {
        super.method_131();
        int dWheel = Mouse.getEventDWheel() / 50;
        if (dWheel != 0) {
            int mouseX = Mouse.getEventX() * this.field_152 / this.field_151.field_2802;
            int mouseY = this.field_153 - Mouse.getEventY() * this.field_153 / this.field_151.field_2803 - 1;
            this.mouseScrolled(mouseX, mouseY, dWheel);
        }
    }

    public void mouseScrolled(double double_1, double double_2, double double_3) {
        if (this.modList.isMouseOver(double_1, double_2)) {
            this.modList.mouseScrolled(double_1, double_2, double_3);
        }
        if (this.descriptionListWidget.isMouseOver(double_1, double_2)) {
            this.descriptionListWidget.mouseScrolled(double_1, double_2, double_3);
        }
    }

    public void method_122() {
        this.searchBox.updateCursorCounter();
    }

    public void method_119() {
        int filtersX;
        Keyboard.enableRepeatEvents((boolean)true);
        class_34 font = this.field_156;
        this.paneY = 48;
        this.paneWidth = this.field_152 / 2 - 8;
        this.rightPaneX = this.field_152 - this.paneWidth;
        int searchBoxWidth = this.paneWidth - 32 - 22;
        this.searchBoxX = this.paneWidth / 2 - searchBoxWidth / 2 - 11;
        String oldText = this.searchBox == null ? "" : this.searchBox.getText();
        this.searchBox = new TextFieldWidget(this.field_156, this.searchBoxX, 22, searchBoxWidth, 20);
        this.searchBox.setText(oldText);
        this.modList = new ModListWidget(this.field_151, this.paneWidth, this.field_153, this.paneY + 19, this.field_153 - 36, 36, this.searchBox.getText(), this.modList, this);
        this.modList.setLeftPos(0);
        this.descriptionListWidget = new DescriptionListWidget(this.field_151, this.paneWidth, this.field_153, this.paneY + 60, this.field_153 - 36, 10, this);
        this.descriptionListWidget.setLeftPos(this.rightPaneX);
        ModMenuTexturedButtonWidget configureButton = new ModMenuTexturedButtonWidget(0, this.field_152 - 24, this.paneY, 20, 20, 0, 0, CONFIGURE_BUTTON_LOCATION, 32, 64){

            @Override
            public void method_1186(Minecraft mc, int mouseX, int mouseY) {
                String modid;
                this.field_1374 = ModListScreen.this.selected != null ? ModMenu.hasConfigScreenFactory(modid = ModListScreen.this.selected.getMetadata().getId()) || ModMenu.hasLegacyConfigScreenTask(modid) : false;
                this.field_1375 = this.field_1374;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                super.method_1186(mc, mouseX, mouseY);
            }
        };
        int urlButtonWidths = this.paneWidth / 2 - 2;
        int cappedButtonWidth = Math.min(urlButtonWidths, 200);
        class_33 websiteButton = new class_33(1, this.rightPaneX + urlButtonWidths / 2 - cappedButtonWidth / 2, this.paneY + 36, Math.min(urlButtonWidths, 200), 20, "Website"){

            public void method_1186(Minecraft mc, int var1, int var2) {
                this.field_1375 = ModListScreen.this.selected != null;
                this.field_1374 = this.field_1375 && ModListScreen.this.selected.getMetadata().getContact().get("homepage").isPresent();
                super.method_1186(mc, var1, var2);
            }
        };
        class_33 issuesButton = new class_33(2, this.rightPaneX + urlButtonWidths + 4 + urlButtonWidths / 2 - cappedButtonWidth / 2, this.paneY + 36, Math.min(urlButtonWidths, 200), 20, "Issues"){

            public void method_1186(Minecraft mc, int var1, int var2) {
                this.field_1375 = ModListScreen.this.selected != null;
                this.field_1374 = this.field_1375 && ModListScreen.this.selected.getMetadata().getContact().get("issues").isPresent();
                super.method_1186(mc, var1, var2);
            }
        };
        this.field_154.add(new ModMenuTexturedButtonWidget(3, this.paneWidth / 2 + searchBoxWidth / 2 - 10 + 2, 22, 20, 20, 0, 0, FILTERS_BUTTON_LOCATION, 32, 64){

            @Override
            public void method_1186(Minecraft mc, int int_1, int int_2) {
                super.method_1186(mc, int_1, int_2);
                if (this.isHovered(int_1, int_2)) {
                    ModListScreen.this.setTooltip("Toggle Filter Options");
                }
            }
        });
        String showLibrariesText = ModMenuConfigManager.getConfig().showLibraries() ? "Libraries: Shown" : "Libraries: Hidden";
        String sortingText = "Sort: " + ModMenuConfigManager.getConfig().getSorting().getName();
        int showLibrariesWidth = font.method_1901(showLibrariesText) + 20;
        int sortingWidth = font.method_1901(sortingText) + 20;
        int filtersWidth = showLibrariesWidth + sortingWidth + 2;
        if (filtersWidth + font.method_1901("Showing " + NumberFormat.getInstance().format(FabricLoader.getInstance().getAllMods().size()) + "/" + NumberFormat.getInstance().format(FabricLoader.getInstance().getAllMods().size()) + " Mods") + 20 >= this.searchBoxX + searchBoxWidth + 22) {
            filtersX = this.paneWidth / 2 - filtersWidth / 2;
            this.showModCount = false;
        } else {
            filtersX = this.searchBoxX + searchBoxWidth + 22 - filtersWidth + 1;
            this.showModCount = true;
        }
        this.field_154.add(new class_33(4, filtersX, 45, sortingWidth, 20, sortingText){

            public void method_1186(Minecraft mc, int mouseX, int mouseY) {
                this.field_1375 = this.field_1374 = ModListScreen.this.filterOptionsShown;
                this.field_1372 = "Sort: " + ModMenuConfigManager.getConfig().getSorting().getName();
                super.method_1186(mc, mouseX, mouseY);
            }
        });
        this.field_154.add(new class_33(5, filtersX + sortingWidth + 2, 45, showLibrariesWidth, 20, showLibrariesText){

            public void method_1186(Minecraft mc, int mouseX, int mouseY) {
                this.field_1375 = this.field_1374 = ModListScreen.this.filterOptionsShown;
                this.field_1372 = ModMenuConfigManager.getConfig().showLibraries() ? "Libraries: Shown" : "Libraries: Hidden";
                super.method_1186(mc, mouseX, mouseY);
            }
        });
        this.field_154.add(configureButton);
        this.field_154.add(websiteButton);
        this.field_154.add(issuesButton);
        this.field_154.add(GuiButtonAccessor.createButton(6, this.field_152 / 2 - 154, this.field_153 - 28, 150, 20, "Open Mods Folder"));
        this.field_154.add(GuiButtonAccessor.createButton(7, this.field_152 / 2 + 4, this.field_153 - 28, 150, 20, "Done"));
        this.searchBox.setFocused(true);
        this.init = true;
    }

    protected void method_120(class_33 button) {
        switch (button.field_1373) {
            case 0: {
                String modid = Objects.requireNonNull(this.selected).getMetadata().getId();
                class_32 screen = ModMenu.getConfigScreen(modid, this);
                if (screen != null) {
                    this.field_151.method_2112(screen);
                    break;
                }
                ModMenu.openConfigScreen(modid);
                break;
            }
            case 1: {
                ModMetadata metadata = Objects.requireNonNull(this.selected).getMetadata();
                metadata.getContact().get("homepage").ifPresent(Sys::openURL);
                break;
            }
            case 2: {
                ModMetadata metadata = Objects.requireNonNull(this.selected).getMetadata();
                metadata.getContact().get("issues").ifPresent(Sys::openURL);
                break;
            }
            case 3: {
                this.filterOptionsShown = !this.filterOptionsShown;
                break;
            }
            case 4: {
                ModMenuConfigManager.getConfig().toggleSortMode();
                this.modList.reloadFilters();
                break;
            }
            case 5: {
                ModMenuConfigManager.getConfig().toggleShowLibraries();
                this.modList.reloadFilters();
                break;
            }
            case 6: {
                File modsFolder = new File(FabricLoader.getInstance().getGameDirectory(), "mods");
                try {
                    Sys.openURL((String)modsFolder.toURI().toURL().toString());
                }
                catch (MalformedURLException e) {
                    LOGGER.error("Malformed mods folder URL", (Throwable)e);
                }
                break;
            }
            case 7: {
                this.field_151.method_2112(this.parent);
            }
        }
    }

    public ModListWidget getModList() {
        return this.modList;
    }

    public void method_117(char char_1, int int_1) {
        this.searchBox.textboxKeyTyped(char_1, int_1);
        super.method_117(char_1, int_1);
        this.modList.keyPressed(int_1, 0, 0);
        this.descriptionListWidget.keyPressed(int_1, 0, 0);
    }

    protected void method_124(int mouseX, int mouseY, int mouseButton) {
        super.method_124(mouseX, mouseY, mouseButton);
        this.modList.mouseClicked(mouseX, mouseY, mouseButton);
        this.descriptionListWidget.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void method_128(int mouseX, int mouseY, int mouseButton) {
        super.method_128(mouseX, mouseY, mouseButton);
        if (mouseButton != -1) {
            this.modList.mouseReleased(mouseX, mouseY, mouseButton);
            this.descriptionListWidget.mouseReleased(mouseX, mouseY, mouseButton);
        }
    }

    public void method_118(int mouseX, int mouseY, float delta) {
        int mouseDX = Mouse.getEventDX() * this.field_152 / this.field_151.field_2802;
        int mouseDY = this.field_153 - Mouse.getEventDY() * this.field_153 / this.field_151.field_2803 - 1;
        for (int button = 0; button < Mouse.getButtonCount(); ++button) {
            if (!Mouse.isButtonDown((int)button)) continue;
            this.modList.mouseDragged(mouseX, mouseY, button, mouseDX, mouseDY);
            this.descriptionListWidget.mouseDragged(mouseX, mouseY, button, mouseDX, mouseDY);
        }
        class_34 font = this.field_156;
        if (!this.searchBox.getText().equals(this.lastSearchString)) {
            this.lastSearchString = this.searchBox.getText();
            this.modList.filter(this.lastSearchString, false);
        }
        this.overlayBackground(this.paneWidth, 0, this.rightPaneX, this.field_153, 64, 64, 64, 255, 255);
        this.tooltip = null;
        ModListEntry selectedEntry = this.selected;
        if (selectedEntry != null) {
            this.descriptionListWidget.method_118(mouseX, mouseY, delta);
        }
        this.modList.method_118(mouseX, mouseY, delta);
        this.searchBox.drawTextBox();
        GL11.glDisable((int)3042);
        this.method_1934(font, this.textTitle, this.modList.getWidth() / 2, 8, 0xFFFFFF);
        super.method_118(mouseX, mouseY, delta);
        if (this.showModCount || !this.filterOptionsShown) {
            font.method_1906("Showing " + NumberFormat.getInstance().format(this.modList.getDisplayedCount()) + "/" + NumberFormat.getInstance().format(FabricLoader.getInstance().getAllMods().size()) + " Mods", this.searchBoxX, 52, 0xFFFFFF);
        }
        if (selectedEntry != null) {
            ModMetadata metadata = selectedEntry.getMetadata();
            int x = this.rightPaneX;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.selected.bindIconTexture();
            GL11.glEnable((int)3042);
            class_67 tess = class_67.field_2054;
            tess.method_1695();
            tess.method_1688((double)x, (double)this.paneY, 0.0, 0.0, 0.0);
            tess.method_1688((double)x, (double)(this.paneY + 32), 0.0, 0.0, 1.0);
            tess.method_1688((double)(x + 32), (double)(this.paneY + 32), 0.0, 1.0, 1.0);
            tess.method_1688((double)(x + 32), (double)this.paneY, 0.0, 1.0, 0.0);
            tess.method_1685();
            GL11.glDisable((int)3042);
            int lineSpacing = 10;
            int imageOffset = 36;
            String name = metadata.getName();
            name = HardcodedUtil.formatFabricModuleName(name);
            Object trimmedName = name;
            int maxNameWidth = this.field_152 - (x + imageOffset);
            if (font.method_1901(name) > maxNameWidth) {
                int maxWidth = maxNameWidth - font.method_1901("...");
                trimmedName = "";
                while (font.method_1901((String)trimmedName) < maxWidth && ((String)trimmedName).length() < name.length()) {
                    trimmedName = (String)trimmedName + name.charAt(((String)trimmedName).length());
                }
                trimmedName = ((String)trimmedName).isEmpty() ? "..." : ((String)trimmedName).substring(0, ((String)trimmedName).length() - 1) + "...";
            }
            font.method_1906((String)trimmedName, x + imageOffset, this.paneY + 1, 0xFFFFFF);
            if (mouseX > x + imageOffset && mouseY > this.paneY + 1 && mouseY < this.paneY + 1 + 9 && mouseX < x + imageOffset + font.method_1901((String)trimmedName)) {
                this.setTooltip("Mod ID: " + metadata.getId());
            }
            if (this.init || this.badgeRenderer == null || this.badgeRenderer.getMetadata() != metadata) {
                this.badgeRenderer = new BadgeRenderer(this.field_151, x + imageOffset + font.method_1901((String)trimmedName) + 2, this.paneY, this.field_152 - 28, selectedEntry.container, this);
                this.init = false;
            }
            this.badgeRenderer.draw(mouseX, mouseY);
            font.method_1906("v" + metadata.getVersion().getFriendlyString(), x + imageOffset, this.paneY + 2 + lineSpacing, 0x808080);
            ArrayList names = new ArrayList();
            metadata.getAuthors().stream().filter(Objects::nonNull).map(Person::getName).filter(Objects::nonNull).forEach(names::add);
            if (!names.isEmpty()) {
                String authors = names.size() > 1 ? Joiner.on((String)", ").join(names) : (String)names.get(0);
                RenderUtils.INSTANCE.drawWrappedString(font, "By " + authors, x + imageOffset, this.paneY + 2 + lineSpacing * 2, this.paneWidth - imageOffset - 4, 1, 0x808080);
            }
            if (this.tooltip != null) {
                this.renderTooltip(Lists.newArrayList((Iterable)Splitter.on((String)"\n").split((CharSequence)this.tooltip)), mouseX, mouseY);
            }
        }
    }

    public void overlayBackground(int x1, int y1, int x2, int y2, int red, int green, int blue, int startAlpha, int endAlpha) {
        class_67 tessellator = class_67.field_2054;
        this.field_151.field_2814.method_1097(this.field_151.field_2814.method_1100("/gui/background.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tessellator.method_1695();
        tessellator.method_1694(red, green, blue, endAlpha);
        tessellator.method_1688((double)x1, (double)y2, 0.0, (double)((float)x1 / 32.0f), (double)((float)y2 / 32.0f));
        tessellator.method_1688((double)x2, (double)y2, 0.0, (double)((float)x2 / 32.0f), (double)((float)y2 / 32.0f));
        tessellator.method_1694(red, green, blue, startAlpha);
        tessellator.method_1688((double)x2, (double)y1, 0.0, (double)((float)x2 / 32.0f), (double)((float)y1 / 32.0f));
        tessellator.method_1688((double)x1, (double)y1, 0.0, (double)((float)x1 / 32.0f), (double)((float)y1 / 32.0f));
        tessellator.method_1685();
    }

    public void method_133() {
        super.method_133();
        this.modList.close();
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public ModListEntry getSelectedEntry() {
        return this.selected;
    }

    public void updateSelectedEntry(ModListEntry entry) {
        if (entry != null) {
            this.selected = entry;
        }
    }

    public double getScrollPercent() {
        return this.scrollPercent;
    }

    public void updateScrollPercent(double scrollPercent) {
        this.scrollPercent = scrollPercent;
    }

    public String getSearchInput() {
        return this.searchBox.getText();
    }

    public boolean showingFilterOptions() {
        return this.filterOptionsShown;
    }

    public void renderTooltip(List<String> list, int i, int j) {
        if (!list.isEmpty()) {
            class_34 font = this.field_156;
            GL11.glDisable((int)32826);
            GL11.glDisable((int)2929);
            int k = 0;
            for (String string : list) {
                int l = font.method_1901(string);
                if (l <= k) continue;
                k = l;
            }
            int m = i + 12;
            int n = j - 12;
            int p = 8;
            if (list.size() > 1) {
                p += 2 + (list.size() - 1) * 10;
            }
            if (m + k > this.field_152) {
                m -= 28 + k;
            }
            if (n + p + 6 > this.field_153) {
                n = this.field_153 - p - 6;
            }
            int transparentGrey = -1073741824;
            int margin = 3;
            this.method_1933(m - margin, n - margin, m + k + margin, n + p + margin, transparentGrey, transparentGrey);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)300.0f);
            for (int t = 0; t < list.size(); ++t) {
                String string2 = list.get(t);
                if (string2 != null) {
                    font.method_1906(string2, m, n, 0xFFFFFF);
                }
                if (t == 0) {
                    n += 2;
                }
                n += 10;
            }
            GL11.glPopMatrix();
            GL11.glEnable((int)2929);
            GL11.glEnable((int)32826);
        }
    }

    protected void method_1933(int i, int j, int k, int l, int m, int n) {
        float f = (float)(m >> 24 & 0xFF) / 255.0f;
        float g = (float)(m >> 16 & 0xFF) / 255.0f;
        float h = (float)(m >> 8 & 0xFF) / 255.0f;
        float o = (float)(m & 0xFF) / 255.0f;
        float p = (float)(n >> 24 & 0xFF) / 255.0f;
        float q = (float)(n >> 16 & 0xFF) / 255.0f;
        float r = (float)(n >> 8 & 0xFF) / 255.0f;
        float s = (float)(n & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        class_67 tessellator = class_67.field_2054;
        tessellator.method_1695();
        tessellator.method_1690(g, h, o, f);
        tessellator.method_1687((double)k, (double)j, 300.0);
        tessellator.method_1687((double)i, (double)j, 300.0);
        tessellator.method_1690(q, r, s, p);
        tessellator.method_1687((double)i, (double)l, 300.0);
        tessellator.method_1687((double)k, (double)l, 300.0);
        tessellator.method_1685();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }
}

