/*
 * Decompiled with CFR 0.152.
 */
package io.github.prospector.modmenu.gui;

import io.github.prospector.modmenu.gui.EntryListWidget;
import io.github.prospector.modmenu.gui.ModListEntry;
import io.github.prospector.modmenu.gui.ModListScreen;
import io.github.prospector.modmenu.util.HardcodedUtil;
import io.github.prospector.modmenu.util.RenderUtils;
import net.minecraft.class_34;
import net.minecraft.client.Minecraft;

public class DescriptionListWidget
extends EntryListWidget<DescriptionEntry> {
    private final ModListScreen parent;
    private final class_34 textRenderer;
    private ModListEntry lastSelected = null;

    public DescriptionListWidget(Minecraft client, int width, int height, int top, int bottom, int entryHeight, ModListScreen parent) {
        super(client, width, height, top, bottom, entryHeight);
        this.parent = parent;
        this.textRenderer = client.field_2815;
    }

    @Override
    public DescriptionEntry getSelected() {
        return null;
    }

    @Override
    public int getRowWidth() {
        return this.width - 10;
    }

    @Override
    protected int getScrollbarPosition() {
        return this.width - 6 + this.left;
    }

    @Override
    public void method_118(int mouseX, int mouseY, float delta) {
        ModListEntry selectedEntry = this.parent.getSelectedEntry();
        if (selectedEntry != this.lastSelected) {
            this.lastSelected = selectedEntry;
            this.clearEntries();
            this.setScrollAmount(-1.7976931348623157E308);
            String description = this.lastSelected.getMetadata().getDescription();
            String id = this.lastSelected.getMetadata().getId();
            if (description.isEmpty() && HardcodedUtil.getHardcodedDescriptions().containsKey(id)) {
                description = HardcodedUtil.getHardcodedDescription(id);
            }
            if (this.lastSelected != null && description != null && !description.isEmpty()) {
                for (String line : RenderUtils.INSTANCE.wrapStringToWidthAsList(this.textRenderer, description.replaceAll("\n", "\n\n"), this.getRowWidth())) {
                    this.children().add(new DescriptionEntry(this.textRenderer, line));
                }
            }
        }
        super.method_118(mouseX, mouseY, delta);
    }

    @Override
    protected void renderHoleBackground(int y1, int y2, int startAlpha, int endAlpha) {
        this.parent.overlayBackground(this.left, y1, this.right, y2, 64, 64, 64, startAlpha, endAlpha);
    }

    protected class DescriptionEntry
    extends EntryListWidget.Entry<DescriptionEntry> {
        protected class_34 _textRenderer;
        protected String text;

        public DescriptionEntry(class_34 textRenderer1, String text) {
            this._textRenderer = textRenderer1;
            this.text = text;
        }

        @Override
        public void render(int index, int y, int x, int itemWidth, int itemHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            this._textRenderer.method_1906(this.text, x, y, 0xAAAAAA);
        }
    }
}

