/*
 * Decompiled with CFR 0.152.
 */
package io.github.prospector.modmenu.gui;

import com.google.common.collect.Lists;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_189;
import net.minecraft.class_32;
import net.minecraft.class_67;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

@Environment(value=EnvType.CLIENT)
public abstract class EntryListWidget<E extends Entry<E>>
extends class_32 {
    protected static final int DRAG_OUTSIDE = -2;
    protected final Minecraft minecraft;
    protected final int itemHeight;
    private final List<E> children = new Entries();
    protected int width;
    protected int height;
    protected int top;
    protected int bottom;
    protected int right;
    protected int left;
    protected boolean centerListVertically = true;
    protected int yDrag = -2;
    private double scrollAmount;
    protected boolean renderSelection = true;
    protected boolean renderHeader;
    protected int headerHeight;
    private boolean scrolling;
    private E selected;
    private E focused;
    private boolean dragging;
    double oldY = -1.0;

    public EntryListWidget(Minecraft minecraftClient, int i, int j, int k, int l, int m) {
        this.minecraft = minecraftClient;
        this.width = i;
        this.height = j;
        this.top = k;
        this.bottom = l;
        this.itemHeight = m;
        this.left = 0;
        this.right = i;
    }

    public void setRenderSelection(boolean bl) {
        this.renderSelection = bl;
    }

    protected void setRenderHeader(boolean bl, int i) {
        this.renderHeader = bl;
        this.headerHeight = i;
        if (!bl) {
            this.headerHeight = 0;
        }
    }

    public int getRowWidth() {
        return 220;
    }

    @Nullable
    public E getSelected() {
        return this.selected;
    }

    public void setSelected(@Nullable E entry) {
        this.selected = entry;
    }

    @Nullable
    public E getFocused() {
        return this.focused;
    }

    public void setFocused(E focused) {
        this.focused = focused;
    }

    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }

    public final List<E> children() {
        return this.children;
    }

    protected final void clearEntries() {
        this.children.clear();
    }

    protected void replaceEntries(Collection<E> collection) {
        this.children.clear();
        this.children.addAll(collection);
    }

    protected E getEntry(int i) {
        return (E)((Object)((Entry)((Object)this.children().get(i))));
    }

    protected int addEntry(E entry) {
        this.children.add(entry);
        return this.children.size() - 1;
    }

    protected int getItemCount() {
        return this.children().size();
    }

    protected boolean isSelectedItem(int i) {
        return Objects.equals(this.getSelected(), this.children().get(i));
    }

    @Nullable
    protected final E getEntryAtPosition(double d, double e) {
        int i = this.getRowWidth() / 2;
        int j = this.left + this.width / 2;
        int k = j - i;
        int l = j + i;
        int m = class_189.method_645((double)(e - (double)this.top)) - this.headerHeight + (int)this.getScrollAmount() - 4;
        int n = m / this.itemHeight;
        return (E)((Object)(d < (double)this.getScrollbarPosition() && d >= (double)k && d <= (double)l && n >= 0 && m >= 0 && n < this.getItemCount() ? (Entry)((Object)this.children().get(n)) : null));
    }

    public void updateSize(int i, int j, int k, int l) {
        this.width = i;
        this.height = j;
        this.top = k;
        this.bottom = l;
        this.left = 0;
        this.right = i;
    }

    public void setLeftPos(int i) {
        this.left = i;
        this.right = i + this.width;
    }

    protected int getMaxPosition() {
        return this.getItemCount() * this.itemHeight + this.headerHeight;
    }

    protected void clickedHeader(int i, int j) {
    }

    protected void renderHeader(int i, int j, class_67 tessellator) {
    }

    public void method_134() {
    }

    protected void renderDecorations(int i, int j) {
    }

    public void method_118(int i, int j, float f) {
        this.oldY = j;
        this.method_134();
        int k = this.getScrollbarPosition();
        int l = k + 6;
        class_67 tessellator = class_67.field_2054;
        this.minecraft.field_2814.method_1097(this.minecraft.field_2814.method_1100("/gui/background.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float g = 32.0f;
        tessellator.method_1695();
        tessellator.method_1693(32, 32, 32);
        tessellator.method_1688((double)this.left, (double)this.bottom, 0.0, (double)((float)this.left / 32.0f), (double)((float)(this.bottom + (int)this.getScrollAmount()) / 32.0f));
        tessellator.method_1688((double)this.right, (double)this.bottom, 0.0, (double)((float)this.right / 32.0f), (double)((float)(this.bottom + (int)this.getScrollAmount()) / 32.0f));
        tessellator.method_1688((double)this.right, (double)this.top, 0.0, (double)((float)this.right / 32.0f), (double)((float)(this.top + (int)this.getScrollAmount()) / 32.0f));
        tessellator.method_1688((double)this.left, (double)this.top, 0.0, (double)((float)this.left / 32.0f), (double)((float)(this.top + (int)this.getScrollAmount()) / 32.0f));
        tessellator.method_1685();
        int m = this.getRowLeft();
        int n = this.top + 4 - (int)this.getScrollAmount();
        if (this.renderHeader) {
            this.renderHeader(m, n, tessellator);
        }
        this.renderList(m, n, i, j, f);
        GL11.glDisable((int)2929);
        this.renderHoleBackground(0, this.top, 255, 255);
        this.renderHoleBackground(this.bottom, this.height, 255, 255);
        GL11.glEnable((int)3042);
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)0, (int)1);
        GL11.glDisable((int)3008);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)3553);
        boolean o = true;
        tessellator.method_1695();
        tessellator.method_1694(0, 0, 0, 0);
        tessellator.method_1688((double)this.left, (double)(this.top + 4), 0.0, 0.0, 1.0);
        tessellator.method_1688((double)this.right, (double)(this.top + 4), 0.0, 1.0, 1.0);
        tessellator.method_1693(0, 0, 0);
        tessellator.method_1688((double)this.right, (double)this.top, 0.0, 1.0, 0.0);
        tessellator.method_1688((double)this.left, (double)this.top, 0.0, 0.0, 0.0);
        tessellator.method_1685();
        tessellator.method_1695();
        tessellator.method_1693(0, 0, 0);
        tessellator.method_1688((double)this.left, (double)this.bottom, 0.0, 0.0, 1.0);
        tessellator.method_1688((double)this.right, (double)this.bottom, 0.0, 1.0, 1.0);
        tessellator.method_1694(0, 0, 0, 0);
        tessellator.method_1688((double)this.right, (double)(this.bottom - 4), 0.0, 1.0, 0.0);
        tessellator.method_1688((double)this.left, (double)(this.bottom - 4), 0.0, 0.0, 0.0);
        tessellator.method_1685();
        int p = this.getMaxScroll();
        if (p > 0) {
            int q = (int)((float)((this.bottom - this.top) * (this.bottom - this.top)) / (float)this.getMaxPosition());
            if (q < 32) {
                q = 32;
            } else if (q > this.bottom - this.top - 8) {
                q = this.bottom - this.top - 8;
            }
            int r = (int)this.getScrollAmount() * (this.bottom - this.top - q) / p + this.top;
            if (r < this.top) {
                r = this.top;
            }
            tessellator.method_1695();
            tessellator.method_1693(0, 0, 0);
            tessellator.method_1688((double)k, (double)this.bottom, 0.0, 0.0, 1.0);
            tessellator.method_1688((double)l, (double)this.bottom, 0.0, 1.0, 1.0);
            tessellator.method_1688((double)l, (double)this.top, 0.0, 1.0, 0.0);
            tessellator.method_1688((double)k, (double)this.top, 0.0, 0.0, 0.0);
            tessellator.method_1685();
            tessellator.method_1695();
            tessellator.method_1693(128, 128, 128);
            tessellator.method_1688((double)k, (double)(r + q), 0.0, 0.0, 1.0);
            tessellator.method_1688((double)l, (double)(r + q), 0.0, 1.0, 1.0);
            tessellator.method_1688((double)l, (double)r, 0.0, 1.0, 0.0);
            tessellator.method_1688((double)k, (double)r, 0.0, 0.0, 0.0);
            tessellator.method_1685();
            tessellator.method_1695();
            tessellator.method_1693(192, 192, 192);
            tessellator.method_1688((double)k, (double)(r + q - 1), 0.0, 0.0, 1.0);
            tessellator.method_1688((double)(l - 1), (double)(r + q - 1), 0.0, 1.0, 1.0);
            tessellator.method_1688((double)(l - 1), (double)r, 0.0, 1.0, 0.0);
            tessellator.method_1688((double)k, (double)r, 0.0, 0.0, 0.0);
            tessellator.method_1685();
        }
        this.renderDecorations(i, j);
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2929);
    }

    protected void centerScrollOn(E entry) {
        this.setScrollAmount(this.children().indexOf(entry) * this.itemHeight + this.itemHeight / 2 - (this.bottom - this.top) / 2);
    }

    protected void ensureVisible(E entry) {
        int k;
        int i = this.getRowTop(this.children().indexOf(entry));
        int j = i - this.top - 4 - this.itemHeight;
        if (j < 0) {
            this.scroll(j);
        }
        if ((k = this.bottom - i - this.itemHeight - this.itemHeight) < 0) {
            this.scroll(-k);
        }
    }

    private void scroll(int i) {
        this.setScrollAmount(this.getScrollAmount() + (double)i);
        this.yDrag = -2;
    }

    public double getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > (double)this.getMaxScroll()) {
            d = this.getMaxScroll();
        }
        this.scrollAmount = d;
    }

    private int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - (this.bottom - this.top - 4));
    }

    public int getScrollBottom() {
        return (int)this.getScrollAmount() - this.height - this.headerHeight;
    }

    protected void updateScrollingState(double d, double e, int i) {
        this.scrolling = i == 0 && d >= (double)this.getScrollbarPosition() && d < (double)(this.getScrollbarPosition() + 6);
    }

    protected int getScrollbarPosition() {
        return this.width / 2 + 124;
    }

    public boolean mouseClicked(double d, double e, int i) {
        this.updateScrollingState(d, e, i);
        if (!this.isMouseOver(d, e)) {
            return false;
        }
        E entry = this.getEntryAtPosition(d, e);
        if (entry != null) {
            if (((Entry)((Object)entry)).mouseClicked(d, e, i)) {
                this.focused = entry;
                this.dragging = true;
                return true;
            }
        } else if (i == 0) {
            this.clickedHeader((int)(d - (double)(this.left + this.width / 2 - this.getRowWidth() / 2)), (int)(e - (double)this.top) + (int)this.getScrollAmount() - 4);
            return true;
        }
        return this.scrolling;
    }

    public boolean mouseReleased(double d, double e, int i) {
        if (this.getFocused() != null) {
            ((Entry)((Object)this.getFocused())).mouseReleased(d, e, i);
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double mouseDX, double mouseDY) {
        if (mouseButton == 0 && this.isMouseOver(mouseX, mouseY)) {
            this.setScrollAmount(this.getScrollAmount() - mouseY + this.oldY);
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double d, double e, double f) {
        this.setScrollAmount(this.getScrollAmount() - f * (double)this.itemHeight / 2.0);
        return true;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.getFocused() != null && ((Entry)((Object)this.getFocused())).keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 264) {
            this.moveSelection(1);
            return true;
        }
        if (keyCode == 265) {
            this.moveSelection(-1);
            return true;
        }
        return false;
    }

    protected void moveSelection(int i) {
        if (!this.children().isEmpty()) {
            int j = this.children().indexOf(this.getSelected());
            int k = j + i;
            if (k < 0) {
                k = 0;
            } else if (k > this.getItemCount() - 1) {
                k = this.getItemCount() - 1;
            }
            Entry entry = (Entry)((Object)this.children().get(k));
            this.setSelected(entry);
            this.ensureVisible(entry);
        }
    }

    public boolean isMouseOver(double d, double e) {
        return e >= (double)this.top && e <= (double)this.bottom && d >= (double)this.left && d <= (double)this.right;
    }

    protected void renderList(int i, int j, int k, int l, float f) {
        int m = this.getItemCount();
        class_67 tessellator = class_67.field_2054;
        for (int n = 0; n < m; ++n) {
            int v;
            int o = this.getRowTop(n);
            int p = this.getRowBottom(n);
            if (p < this.top || o > this.bottom) continue;
            int q = j + n * this.itemHeight + this.headerHeight;
            int r = this.itemHeight - 4;
            E entry = this.getEntry(n);
            int s = this.getRowWidth();
            if (this.renderSelection && this.isSelectedItem(n)) {
                v = this.left + this.width / 2 - s / 2;
                int u = this.left + this.width / 2 + s / 2;
                GL11.glDisable((int)3553);
                float g = this.isFocused() ? 1.0f : 0.5f;
                GL11.glColor4f((float)g, (float)g, (float)g, (float)1.0f);
                tessellator.method_1695();
                tessellator.method_1687((double)v, (double)(q + r + 2), 0.0);
                tessellator.method_1687((double)u, (double)(q + r + 2), 0.0);
                tessellator.method_1687((double)u, (double)(q - 2), 0.0);
                tessellator.method_1687((double)v, (double)(q - 2), 0.0);
                tessellator.method_1685();
                GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                tessellator.method_1695();
                tessellator.method_1687((double)(v + 1), (double)(q + r + 1), 0.0);
                tessellator.method_1687((double)(u - 1), (double)(q + r + 1), 0.0);
                tessellator.method_1687((double)(u - 1), (double)(q - 1), 0.0);
                tessellator.method_1687((double)(v + 1), (double)(q - 1), 0.0);
                tessellator.method_1685();
                GL11.glEnable((int)3553);
            }
            v = this.getRowLeft();
            ((Entry)((Object)entry)).render(n, o, v, s, r, k, l, this.isMouseOver(k, l) && Objects.equals(this.getEntryAtPosition(k, l), entry), f);
        }
    }

    protected int getRowLeft() {
        return this.left + this.width / 2 - this.getRowWidth() / 2 + 2;
    }

    protected int getRowTop(int i) {
        return this.top + 4 - (int)this.getScrollAmount() + i * this.itemHeight + this.headerHeight;
    }

    private int getRowBottom(int i) {
        return this.getRowTop(i) + this.itemHeight;
    }

    protected boolean isFocused() {
        return false;
    }

    protected void renderHoleBackground(int i, int j, int k, int l) {
        class_67 tessellator = class_67.field_2054;
        this.minecraft.field_2814.method_1097(this.minecraft.field_2814.method_1100("/gui/background.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f = 32.0f;
        tessellator.method_1695();
        tessellator.method_1694(64, 64, 64, l);
        tessellator.method_1688((double)this.left, (double)j, 0.0, 0.0, (double)((float)j / 32.0f));
        tessellator.method_1688((double)(this.left + this.width), (double)j, 0.0, (double)((float)this.width / 32.0f), (double)((float)j / 32.0f));
        tessellator.method_1694(64, 64, 64, k);
        tessellator.method_1688((double)(this.left + this.width), (double)i, 0.0, (double)((float)this.width / 32.0f), (double)((float)i / 32.0f));
        tessellator.method_1688((double)this.left, (double)i, 0.0, 0.0, (double)((float)i / 32.0f));
        tessellator.method_1685();
    }

    protected E remove(int i) {
        Entry entry = (Entry)((Object)this.children.get(i));
        return (E)((Object)(this.removeEntry((Entry)((Object)this.children.get(i))) ? entry : null));
    }

    protected boolean removeEntry(E entry) {
        boolean bl = this.children.remove(entry);
        if (bl && entry == this.getSelected()) {
            this.setSelected(null);
        }
        return bl;
    }

    @Environment(value=EnvType.CLIENT)
    class Entries
    extends AbstractList<E> {
        private final List<E> entries = Lists.newArrayList();

        private Entries() {
        }

        @Override
        public E get(int i) {
            return (Object)((Entry)((Object)this.entries.get(i)));
        }

        @Override
        public int size() {
            return this.entries.size();
        }

        @Override
        public E set(int i, E entry) {
            Entry entry2 = (Entry)((Object)this.entries.set(i, entry));
            ((Entry)((Object)entry)).list = EntryListWidget.this;
            return (Object)entry2;
        }

        @Override
        public void add(int i, E entry) {
            this.entries.add(i, entry);
            ((Entry)((Object)entry)).list = EntryListWidget.this;
        }

        @Override
        public E remove(int i) {
            return (Object)((Entry)((Object)this.entries.remove(i)));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static abstract class Entry<E extends Entry<E>>
    extends class_32 {
        @Deprecated
        EntryListWidget<E> list;

        public abstract void render(int var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, float var9);

        public boolean isMouseOver(double d, double e) {
            return Objects.equals(this.list.getEntryAtPosition(d, e), (Object)this);
        }

        public void mouseMoved(double d, double e) {
        }

        public boolean mouseClicked(double d, double e, int i) {
            return false;
        }

        public boolean mouseReleased(double d, double e, int i) {
            return false;
        }

        public boolean mouseScrolled(double d, double e, double f) {
            return false;
        }

        public boolean keyPressed(int i, int j, int k) {
            return false;
        }

        public boolean keyReleased(int i, int j, int k) {
            return false;
        }

        public boolean charTyped(char c, int i) {
            return false;
        }

        public boolean changeFocus(boolean bl) {
            return false;
        }
    }
}

