/*
 * Decompiled with CFR 0.152.
 */
package io.github.prospector.modmenu.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_32;
import net.minecraft.class_34;

@Environment(value=EnvType.CLIENT)
public class RenderUtils
extends class_32 {
    public static final RenderUtils INSTANCE = new RenderUtils();

    private RenderUtils() {
    }

    public List<String> wrapStringToWidthAsList(class_34 font, String text, int width) {
        ArrayList words = new ArrayList();
        if (text != null) {
            Collections.addAll(words, text.split(" "));
        }
        ArrayList<String> strings = new ArrayList<String>();
        String current = "";
        while (!words.isEmpty()) {
            String next;
            String nextWord = (String)words.remove(0);
            String string = next = current.isEmpty() ? nextWord : current + " " + nextWord;
            if (font.method_1901(next) > width) {
                strings.add(current);
                current = nextWord;
                continue;
            }
            current = next;
        }
        if (!current.isEmpty()) {
            strings.add(current);
        }
        return strings;
    }

    public void drawWrappedString(class_34 font, String string, int x, int y, int wrapWidth, int lines, int color) {
        while (string != null && string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        List<String> strings = this.wrapStringToWidthAsList(font, string, wrapWidth);
        for (int i = 0; i < strings.size() && i < lines; ++i) {
            Object line = strings.get(i);
            if (i == lines - 1 && strings.size() > lines) {
                line = (String)line + "...";
            }
            int x1 = x;
            font.method_1906((String)line, x1, y + i * 9, color);
        }
    }

    public void drawBadge(class_34 font, int x, int y, int tagWidth, String text, int outlineColor, int fillColor, int textColor) {
        this.method_1932(x + 1, y - 1, x + tagWidth, y, outlineColor);
        this.method_1932(x, y, x + 1, y + 9, outlineColor);
        this.method_1932(x + 1, y + 1 + 9 - 1, x + tagWidth, y + 9 + 1, outlineColor);
        this.method_1932(x + tagWidth, y, x + tagWidth + 1, y + 9, outlineColor);
        this.method_1932(x + 1, y, x + tagWidth, y + 9, fillColor);
        font.method_1906(text, x + 1 + (tagWidth - font.method_1901(text)) / 2, y + 1, textColor);
    }
}

