package io.github.prospector.modmenu.gui;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import io.github.prospector.modmenu.ModMenu;
import io.github.prospector.modmenu.config.ModMenuConfigManager;
import io.github.prospector.modmenu.util.BadgeRenderer;
import io.github.prospector.modmenu.util.HardcodedUtil;
import io.github.prospector.modmenu.util.RenderUtils;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.class_32;
import net.minecraft.class_33;
import net.minecraft.class_34;
import net.minecraft.class_67;
import net.minecraft.client.Minecraft;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.Sys;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;
import org.lwjgl.opengl.GL14;

import java.io.File;
import java.net.MalformedURLException;
import java.text.NumberFormat;
import java.util.*;

public class ModListScreen extends class_32 {
	private static final String FILTERS_BUTTON_LOCATION = "/assets/" + ModMenu.MOD_ID + "/textures/gui/filters_button.png";
	private static final String CONFIGURE_BUTTON_LOCATION = "/assets/" + ModMenu.MOD_ID + "/textures/gui/configure_button.png";
	private static final Logger LOGGER = LogManager.getLogger();
	private final String textTitle;
	private TextFieldWidget searchBox;
	private DescriptionListWidget descriptionListWidget;
	private class_32 parent;
	private ModListWidget modList;
	private String tooltip;
	private ModListEntry selected;
	private BadgeRenderer badgeRenderer;
	private double scrollPercent = 0;
	private boolean showModCount = false;
	private boolean init = false;
	private boolean filterOptionsShown = false;
	private int paneY;
	private int paneWidth;
	private int rightPaneX;
	private int searchBoxX;
	public Set<String> showModChildren = new HashSet<>();
	private String lastSearchString = null;

	private static final int CONFIGURE_BUTTON_ID = 0;
	private static final int WEBSITE_BUTTON_ID = 1;
	private static final int ISSUES_BUTTON_ID = 2;
	private static final int TOGGLE_FILTER_OPTIONS_BUTTON_ID = 3;
	private static final int TOGGLE_SORT_MODE_BUTTON_ID = 4;
	private static final int TOGGLE_SHOW_LIBRARIES_BUTTON_ID = 5;
	private static final int MODS_FOLDER_BUTTON_ID = 6;
	private static final int DONE_BUTTON_ID = 7;

	public ModListScreen(class_32 previousGui) {
		this.parent = previousGui;
		this.textTitle = "Mods";
	}

	@Override
	public void method_131() {
		super.method_131();
		int dWheel = Mouse.getEventDWheel()/50;
		if (dWheel != 0) {
			int mouseX = Mouse.getEventX() * this.field_152 / this.field_151.field_2802; // field_6326_c
			int mouseY = this.field_153 - Mouse.getEventY() * this.field_153 / this.field_151.field_2803 - 1; // field_6325_d
			mouseScrolled(mouseX, mouseY, dWheel);
		}
	}

	public void mouseScrolled(double double_1, double double_2, double double_3) {
		if (modList.isMouseOver(double_1, double_2))
			this.modList.mouseScrolled(double_1, double_2, double_3);
		if (descriptionListWidget.isMouseOver(double_1, double_2))
			this.descriptionListWidget.mouseScrolled(double_1, double_2, double_3);
	}

	@Override
	public void method_122() {
		this.searchBox.updateCursorCounter();
	}

	@SuppressWarnings("unchecked")
	@Override
	public void method_119() {
		Keyboard.enableRepeatEvents(true);
		class_34 font = field_156;
		paneY = 48;
		paneWidth = this.field_152 / 2 - 8;
		rightPaneX = field_152 - paneWidth;

		int searchBoxWidth = paneWidth - 32 - 22;
		searchBoxX = paneWidth / 2 - searchBoxWidth / 2 - 22 / 2;
		String oldText = this.searchBox == null ? "" : this.searchBox.getText();
		this.searchBox = new TextFieldWidget(this.field_156, searchBoxX, 22, searchBoxWidth, 20); // field_6451_g
		this.searchBox.setText(oldText);
		this.modList = new ModListWidget(this.field_151, paneWidth, this.field_153, paneY + 19, this.field_153 - 36, 36, this.searchBox.getText(), this.modList, this);
		this.modList.setLeftPos(0);
		this.descriptionListWidget = new DescriptionListWidget(this.field_151, paneWidth, this.field_153, paneY + 60, this.field_153 - 36, 9 + 1, this);
		this.descriptionListWidget.setLeftPos(rightPaneX);
		class_33 configureButton = new ModMenuTexturedButtonWidget(CONFIGURE_BUTTON_ID, field_152 - 24, paneY, 20, 20, 0, 0, CONFIGURE_BUTTON_LOCATION, 32, 64) {
			@Override
			public void method_1186(Minecraft mc, int mouseX, int mouseY) {
				if (selected != null) {
					String modid = selected.getMetadata().getId();
					field_1374 = ModMenu.hasConfigScreenFactory(modid) || ModMenu.hasLegacyConfigScreenTask(modid);
				} else {
					field_1374 = false;
				}
				field_1375 = field_1374; // visible = enabled
				GL11.glColor4f(1f, 1f, 1f, 1f);
				super.method_1186(mc, mouseX, mouseY);
			}
		};
		int urlButtonWidths = paneWidth / 2 - 2;
		int cappedButtonWidth = Math.min(urlButtonWidths, 200);
		class_33 websiteButton = new class_33(WEBSITE_BUTTON_ID, rightPaneX + (urlButtonWidths / 2) - (cappedButtonWidth / 2), paneY + 36, Math.min(urlButtonWidths, 200), 20, "Website") {
			@Override
			public void method_1186(Minecraft mc, int var1, int var2) {
				field_1375 = selected != null; // visible = selected != null
				field_1374 = field_1375 && selected.getMetadata().getContact().get("homepage").isPresent();
				super.method_1186(mc, var1, var2);
			}
		};
		class_33 issuesButton = new class_33(ISSUES_BUTTON_ID, rightPaneX + urlButtonWidths + 4 + (urlButtonWidths / 2) - (cappedButtonWidth / 2), paneY + 36, Math.min(urlButtonWidths, 200), 20, "Issues") {
			@Override
			public void method_1186(Minecraft mc, int var1, int var2) {
				field_1375 = selected != null; // visible = selected != null
				field_1374 = field_1375  && selected.getMetadata().getContact().get("issues").isPresent();
				super.method_1186(mc, var1, var2);
			}
		};
		this.field_154.add(new ModMenuTexturedButtonWidget(TOGGLE_FILTER_OPTIONS_BUTTON_ID, paneWidth / 2 + searchBoxWidth / 2 - 20 / 2 + 2, 22, 20, 20, 0, 0, FILTERS_BUTTON_LOCATION, 32, 64) {
			@Override
			public void method_1186(Minecraft mc, int int_1, int int_2) {
				super.method_1186(mc, int_1, int_2);
				if (isHovered(int_1, int_2)) {
					setTooltip("Toggle Filter Options");
				}
			}
		});
		String showLibrariesText = ModMenuConfigManager.getConfig().showLibraries() ? "Libraries: Shown" : "Libraries: Hidden";
		String sortingText = "Sort: " + ModMenuConfigManager.getConfig().getSorting().getName();
		int showLibrariesWidth = font.method_1901(showLibrariesText) + 20;
		int sortingWidth = font.method_1901(sortingText) + 20;
		int filtersX;
		int filtersWidth = showLibrariesWidth + sortingWidth + 2;
		if ((filtersWidth + font.method_1901("Showing " + NumberFormat.getInstance().format(FabricLoader.getInstance().getAllMods().size()) + "/" + NumberFormat.getInstance().format(FabricLoader.getInstance().getAllMods().size()) + " Mods") + 20) >= searchBoxX + searchBoxWidth + 22) {
			filtersX = paneWidth / 2 - filtersWidth / 2;
			showModCount = false;
		} else {
			filtersX = searchBoxX + searchBoxWidth + 22 - filtersWidth + 1;
			showModCount = true;
		}
		this.field_154.add(new class_33(TOGGLE_SORT_MODE_BUTTON_ID, filtersX, 45, sortingWidth, 20, sortingText) {
			@Override
			public void method_1186(Minecraft mc, int mouseX, int mouseY) {
				field_1375 = field_1374 = filterOptionsShown;
				this.field_1372 = "Sort: " + ModMenuConfigManager.getConfig().getSorting().getName();
				super.method_1186(mc, mouseX, mouseY);
			}
		});
		this.field_154.add(new class_33(TOGGLE_SHOW_LIBRARIES_BUTTON_ID, filtersX + sortingWidth + 2, 45, showLibrariesWidth, 20, showLibrariesText) {
			@Override
			public void method_1186(Minecraft mc, int mouseX, int mouseY) {
				field_1375 = field_1374 = filterOptionsShown;
				this.field_1372 = ModMenuConfigManager.getConfig().showLibraries() ? "Libraries: Shown" : "Libraries: Hidden";
				super.method_1186(mc, mouseX, mouseY);
			}
		});
		this.field_154.add(configureButton);
		this.field_154.add(websiteButton);
		this.field_154.add(issuesButton);
		this.field_154.add(GuiButtonAccessor.createButton(MODS_FOLDER_BUTTON_ID, this.field_152 / 2 - 154, this.field_153 - 28, 150, 20, "Open Mods Folder"));
		this.field_154.add(GuiButtonAccessor.createButton(DONE_BUTTON_ID, this.field_152 / 2 + 4, this.field_153 - 28, 150, 20, "Done"));
		this.searchBox.setFocused(true);

		init = true;
	}

	@Override
	protected void method_120(class_33 button) {
		switch (button.field_1373) {
			case CONFIGURE_BUTTON_ID: {
				final String modid = Objects.requireNonNull(selected).getMetadata().getId();
				final class_32 screen = ModMenu.getConfigScreen(modid, this);
				if (screen != null) {
					field_151.method_2112(screen);
				} else {
					ModMenu.openConfigScreen(modid);
				}
				break;
			}
			case WEBSITE_BUTTON_ID: {
				final ModMetadata metadata = Objects.requireNonNull(selected).getMetadata();
				metadata.getContact().get("homepage").ifPresent(Sys::openURL);
				break;
			}
			case ISSUES_BUTTON_ID: {
				final ModMetadata metadata = Objects.requireNonNull(selected).getMetadata();
				metadata.getContact().get("issues").ifPresent(Sys::openURL);
				break;
			}
			case TOGGLE_FILTER_OPTIONS_BUTTON_ID: {
				filterOptionsShown = !filterOptionsShown;
				break;
			}
			case TOGGLE_SORT_MODE_BUTTON_ID: {
				ModMenuConfigManager.getConfig().toggleSortMode();
				modList.reloadFilters();
				break;
			}
			case TOGGLE_SHOW_LIBRARIES_BUTTON_ID: {
				ModMenuConfigManager.getConfig().toggleShowLibraries();
				modList.reloadFilters();
				break;
			}
			case MODS_FOLDER_BUTTON_ID: {
				File modsFolder = new File(FabricLoader.getInstance().getGameDirectory(), "mods");
				try {
					Sys.openURL(modsFolder.toURI().toURL().toString());
				} catch (MalformedURLException e) {
					LOGGER.error("Malformed mods folder URL", e);
				}
				break;
			}
			case DONE_BUTTON_ID: {
				field_151.method_2112(parent);
				break;
			}
		}
	}

	public ModListWidget getModList() {
		return modList;
	}

	@Override
	public void method_117(char char_1, int int_1) {
		this.searchBox.textboxKeyTyped(char_1, int_1);
		super.method_117(char_1, int_1);
		modList.keyPressed(int_1, 0, 0);
		descriptionListWidget.keyPressed(int_1, 0, 0);
	}

	@Override
	protected void method_124(int mouseX, int mouseY, int mouseButton) {
		super.method_124(mouseX, mouseY, mouseButton);
		modList.mouseClicked(mouseX, mouseY, mouseButton);
		descriptionListWidget.mouseClicked(mouseX, mouseY, mouseButton);
	}

	@Override
	protected void method_128(int mouseX, int mouseY, int mouseButton) {
		super.method_128(mouseX, mouseY, mouseButton);
		if (mouseButton != -1) {
			modList.mouseReleased(mouseX, mouseY, mouseButton);
			descriptionListWidget.mouseReleased(mouseX, mouseY, mouseButton);
		}
	}

	@Override
	public void method_118(int mouseX, int mouseY, float delta) {
		int mouseDX = Mouse.getEventDX() * this.field_152 / this.field_151.field_2802; // field_6326_c
		int mouseDY = this.field_153 - Mouse.getEventDY() * this.field_153 / this.field_151.field_2803 - 1; // field_6325_d
		for (int button = 0; button < Mouse.getButtonCount(); button++) {
			if (Mouse.isButtonDown(button)) {
				modList.mouseDragged(mouseX, mouseY, button, mouseDX, mouseDY);
				descriptionListWidget.mouseDragged(mouseX, mouseY, button, mouseDX, mouseDY);
			}
		}
		class_34 font = this.field_156;
		if (!searchBox.getText().equals(lastSearchString)) {
			lastSearchString = searchBox.getText();
			modList.filter(lastSearchString, false);
		}
		overlayBackground(paneWidth, 0, rightPaneX, field_153, 64, 64, 64, 255, 255);
		this.tooltip = null;
		ModListEntry selectedEntry = selected;
		if (selectedEntry != null) {
			this.descriptionListWidget.method_118(mouseX, mouseY, delta);
		}
		this.modList.method_118(mouseX, mouseY, delta);
		this.searchBox.drawTextBox();
		GL11.glDisable(GL11.GL_BLEND);
		this.method_1934(font, this.textTitle, this.modList.getWidth() / 2, 8, 0xffffff);
		super.method_118(mouseX, mouseY, delta);
		if (showModCount || !filterOptionsShown) {
			font.method_1906("Showing " + NumberFormat.getInstance().format(modList.getDisplayedCount()) + "/" + NumberFormat.getInstance().format(FabricLoader.getInstance().getAllMods().size()) + " Mods", searchBoxX, 52, 0xFFFFFF);
		}
		if (selectedEntry != null) {
			ModMetadata metadata = selectedEntry.getMetadata();
			int x = rightPaneX;
			GL11.glColor4f(1f, 1f, 1f, 1f);
			this.selected.bindIconTexture();
			GL11.glEnable(GL11.GL_BLEND);
			class_67 tess = class_67.field_2054;
			tess.method_1695();
			tess.method_1688(x, paneY, 0, 0, 0);
			tess.method_1688(x, paneY + 32, 0, 0, 1);
			tess.method_1688(x + 32, paneY + 32, 0, 1, 1);
			tess.method_1688(x + 32, paneY, 0, 1, 0);
			tess.method_1685();
			GL11.glDisable(GL11.GL_BLEND);
			int lineSpacing = 9 + 1;
			int imageOffset = 36;
			String name = metadata.getName();
			name = HardcodedUtil.formatFabricModuleName(name);
			String trimmedName = name;
			int maxNameWidth = this.field_152 - (x + imageOffset);
			if (font.method_1901(name) > maxNameWidth) {
				int maxWidth = maxNameWidth - font.method_1901("...");
				trimmedName = "";
				while (font.method_1901(trimmedName) < maxWidth && trimmedName.length() < name.length()) {
					trimmedName += name.charAt(trimmedName.length());
				}
				trimmedName = trimmedName.isEmpty() ? "..." : trimmedName.substring(0, trimmedName.length() - 1) + "...";
			}
			font.method_1906(trimmedName, x + imageOffset, paneY + 1, 0xFFFFFF);
			if (mouseX > x + imageOffset && mouseY > paneY + 1 && mouseY < paneY + 1 + 9 && mouseX < x + imageOffset + font.method_1901(trimmedName)) {
				setTooltip("Mod ID: " + metadata.getId());
			}
			if (init || badgeRenderer == null || badgeRenderer.getMetadata() != metadata) {
				badgeRenderer = new BadgeRenderer(field_151, x + imageOffset + font.method_1901(trimmedName) + 2, paneY, field_152 - 28, selectedEntry.container, this);
				init = false;
			}
			badgeRenderer.draw(mouseX, mouseY);
			font.method_1906("v" + metadata.getVersion().getFriendlyString(), x + imageOffset, paneY + 2 + lineSpacing, 0x808080);
			String authors;
			List<String> names = new ArrayList<>();

			metadata.getAuthors().stream()
				.filter(Objects::nonNull)
				.map(Person::getName)
				.filter(Objects::nonNull)
				.forEach(names::add);

			if (!names.isEmpty()) {
				if (names.size() > 1) {
					authors = Joiner.on(", ").join(names);
				} else {
					authors = names.get(0);
				}
				RenderUtils.INSTANCE.drawWrappedString(font, "By " + authors, x + imageOffset, paneY + 2 + lineSpacing * 2, paneWidth - imageOffset - 4, 1, 0x808080);
			}
			if (this.tooltip != null) {
				this.renderTooltip(Lists.newArrayList(Splitter.on("\n").split(this.tooltip)), mouseX, mouseY);
			}
		}

	}

	public void overlayBackground(int x1, int y1, int x2, int y2, int red, int green, int blue, int startAlpha, int endAlpha) {
		class_67 tessellator = class_67.field_2054;
		field_151.field_2814.method_1097(field_151.field_2814.method_1100("/gui/background.png"));
		GL11.glColor4f(1f, 1f, 1f, 1f);
		tessellator.method_1695();
		tessellator.method_1694(red, green, blue, endAlpha);
		tessellator.method_1688(x1, y2, 0.0D, x1 / 32.0F, y2 / 32.0F);
		tessellator.method_1688(x2, y2, 0.0D, x2 / 32.0F, y2 / 32.0F);
		tessellator.method_1694(red, green, blue, startAlpha);
		tessellator.method_1688(x2, y1, 0.0D, x2 / 32.0F, y1 / 32.0F);
		tessellator.method_1688(x1, y1, 0.0D, x1 / 32.0F, y1 / 32.0F);
		tessellator.method_1685();
	}

	@Override
	public void method_133() {
		super.method_133();
		this.modList.close();
	}

	public void setTooltip(String tooltip) {
		this.tooltip = tooltip;
	}

	public ModListEntry getSelectedEntry() {
		return selected;
	}

	public void updateSelectedEntry(ModListEntry entry) {
		if (entry != null) {
			this.selected = entry;
		}
	}

	public double getScrollPercent() {
		return scrollPercent;
	}

	public void updateScrollPercent(double scrollPercent) {
		this.scrollPercent = scrollPercent;
	}

	public String getSearchInput() {
		return searchBox.getText();
	}

	public boolean showingFilterOptions() {
		return filterOptionsShown;
	}

	public void renderTooltip(List<String> list, int i, int j) {
		if (!list.isEmpty()) {
			class_34 font = field_156;

			GL11.glDisable(GL12.GL_RESCALE_NORMAL);
			GL11.glDisable(GL11.GL_DEPTH_TEST);
			int k = 0;

			for (String string : list) {
				int l = font.method_1901(string);
				if (l > k) {
					k = l;
				}
			}

			int m = i + 12;
			int n = j - 12;
			int p = 8;
			if (list.size() > 1) {
				p += 2 + (list.size() - 1) * 10;
			}

			if (m + k > this.field_152) {
				m -= 28 + k;
			}

			if (n + p + 6 > this.field_153) {
				n = this.field_153 - p - 6;
			}

			int transparentGrey = -1073741824;
			int margin = 3;
			this.method_1933(m - margin, n - margin, m + k + margin,
					n + p + margin, transparentGrey, transparentGrey);
			GL11.glPushMatrix();
			GL11.glTranslatef(0, 0, 300);

			for(int t = 0; t < list.size(); ++t) {
				String string2 = list.get(t);
				if (string2 != null) {
					font.method_1906(string2, m, n, 0xffffff);
				}

				if (t == 0) {
					n += 2;
				}

				n += 10;
			}

			GL11.glPopMatrix();
			GL11.glEnable(GL11.GL_DEPTH_TEST);
			GL11.glEnable(GL12.GL_RESCALE_NORMAL);
		}
	}

	protected void method_1933(int i, int j, int k, int l, int m, int n) {
		float f = (float)(m >> 24 & 255) / 255.0F;
		float g = (float)(m >> 16 & 255) / 255.0F;
		float h = (float)(m >> 8 & 255) / 255.0F;
		float o = (float)(m & 255) / 255.0F;
		float p = (float)(n >> 24 & 255) / 255.0F;
		float q = (float)(n >> 16 & 255) / 255.0F;
		float r = (float)(n >> 8 & 255) / 255.0F;
		float s = (float)(n & 255) / 255.0F;
		GL11.glDisable(GL11.GL_TEXTURE_2D);
		GL11.glEnable(GL11.GL_BLEND);
		GL11.glDisable(GL11.GL_ALPHA_TEST);
		GL14.glBlendFuncSeparate(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA, GL11.GL_ONE, GL11.GL_ZERO);
		GL11.glShadeModel(GL11.GL_SMOOTH);
		class_67 tessellator = class_67.field_2054;
		tessellator.method_1695();
		tessellator.method_1690(g, h, o, f);
		tessellator.method_1687(k, j, 300);
		tessellator.method_1687(i, j, 300);
		tessellator.method_1690(q, r, s, p);
		tessellator.method_1687(i, l, 300);
		tessellator.method_1687(k, l, 300);
		tessellator.method_1685();
		GL11.glShadeModel(GL11.GL_FLAT);
		GL11.glDisable(GL11.GL_BLEND);
		GL11.glEnable(GL11.GL_ALPHA_TEST);
		GL11.glEnable(GL11.GL_TEXTURE_2D);
	}
}
