/*
 * Decompiled with CFR 0.152.
 */
package io.github.prospector.modmenu.gui;

import io.github.prospector.modmenu.gui.AlwaysSelectedEntryListWidget;
import io.github.prospector.modmenu.gui.ModListWidget;
import io.github.prospector.modmenu.util.BadgeRenderer;
import io.github.prospector.modmenu.util.HardcodedUtil;
import io.github.prospector.modmenu.util.RenderUtils;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import javax.imageio.ImageIO;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_34;
import net.minecraft.class_67;
import net.minecraft.client.Minecraft;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

public class ModListEntry
extends AlwaysSelectedEntryListWidget.Entry<ModListEntry> {
    public static final String UNKNOWN_ICON = "/gui/unknown_pack.png";
    private static final Logger LOGGER = LogManager.getLogger();
    protected final Minecraft client;
    protected final ModContainer container;
    protected final ModMetadata metadata;
    protected final ModListWidget list;
    protected Integer iconLocation;

    public ModListEntry(Minecraft mc, ModContainer container, ModListWidget list) {
        this.container = container;
        this.list = list;
        this.metadata = container.getMetadata();
        this.client = mc;
    }

    @Override
    public void render(int index, int y, int x, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        x += this.getXOffset();
        rowWidth -= this.getXOffset();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindIconTexture();
        GL11.glEnable((int)3042);
        class_67 tess = class_67.field_2054;
        tess.method_1695();
        tess.method_1688((double)x, (double)y, 0.0, 0.0, 0.0);
        tess.method_1688((double)x, (double)(y + 32), 0.0, 0.0, 1.0);
        tess.method_1688((double)(x + 32), (double)(y + 32), 0.0, 1.0, 1.0);
        tess.method_1688((double)(x + 32), (double)y, 0.0, 1.0, 0.0);
        tess.method_1685();
        GL11.glDisable((int)3042);
        String name = HardcodedUtil.formatFabricModuleName(this.metadata.getName());
        Object trimmedName = name;
        int maxNameWidth = rowWidth - 32 - 3;
        class_34 font = this.client.field_2815;
        if (font.method_1901(name) > maxNameWidth) {
            int maxWidth = maxNameWidth - font.method_1901("...");
            trimmedName = "";
            while (font.method_1901((String)trimmedName) < maxWidth && ((String)trimmedName).length() < name.length()) {
                trimmedName = (String)trimmedName + name.charAt(((String)trimmedName).length());
            }
            trimmedName = ((String)trimmedName).isEmpty() ? "..." : ((String)trimmedName).substring(0, ((String)trimmedName).length() - 1) + "...";
        }
        font.method_1906((String)trimmedName, x + 32 + 3, y + 1, 0xFFFFFF);
        new BadgeRenderer(this.client, x + 32 + 3 + font.method_1901(name) + 2, y, x + rowWidth, this.container, this.list.getParent()).draw(mouseX, mouseY);
        String description = this.metadata.getDescription();
        if (description.isEmpty() && HardcodedUtil.getHardcodedDescriptions().containsKey(this.metadata.getId())) {
            description = HardcodedUtil.getHardcodedDescription(this.metadata.getId());
        }
        RenderUtils.INSTANCE.drawWrappedString(font, description, x + 32 + 3 + 4, y + 9 + 2, rowWidth - 32 - 7, 2, 0x808080);
    }

    private BufferedImage createIcon() {
        BufferedImage bufferedImage;
        block12: {
            Path path = this.container.getPath((String)((Object)this.metadata.getIconPath(0).orElse("assets/" + this.metadata.getId() + "/icon.png")));
            BufferedImage cached = this.list.getCachedModIcon(path);
            if (cached != null) {
                return cached;
            }
            if (!Files.exists(path, new LinkOption[0])) {
                ModContainer modMenu = (ModContainer)FabricLoader.getInstance().getModContainer("modmenu").orElseThrow(IllegalAccessError::new);
                path = HardcodedUtil.getFabricMods().contains(this.metadata.getId()) ? modMenu.getPath("assets/modmenu/fabric_icon.png") : (this.metadata.getId().equals("minecraft") ? modMenu.getPath("assets/modmenu/mc_icon.png") : modMenu.getPath("assets/modmenu/grey_fabric_icon.png"));
            }
            if ((cached = this.list.getCachedModIcon(path)) != null) {
                return cached;
            }
            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
            try {
                BufferedImage image = ImageIO.read(Objects.requireNonNull(inputStream));
                if (image.getHeight() != image.getWidth()) {
                    throw new IllegalStateException("Must be square icon");
                }
                this.list.cacheModIcon(path, image);
                bufferedImage = image;
                if (inputStream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    LOGGER.error("Invalid icon for mod {}", (Object)this.container.getMetadata().getName(), (Object)t);
                    return null;
                }
            }
            inputStream.close();
        }
        return bufferedImage;
    }

    @Override
    public boolean mouseClicked(double v, double v1, int i) {
        this.list.select(this);
        return true;
    }

    public ModMetadata getMetadata() {
        return this.metadata;
    }

    public void bindIconTexture() {
        if (this.iconLocation == null) {
            BufferedImage icon = this.createIcon();
            this.iconLocation = icon != null ? Integer.valueOf(this.client.field_2814.method_1088(icon)) : Integer.valueOf(this.client.field_2814.method_1100(UNKNOWN_ICON));
        }
        this.client.field_2814.method_1097(this.iconLocation.intValue());
    }

    public void deleteTexture() {
        if (this.iconLocation != null) {
            this.client.field_2814.method_1085(this.iconLocation.intValue());
        }
    }

    public int getXOffset() {
        return 0;
    }
}

