/*
 * Decompiled with CFR 0.152.
 */
package io.github.prospector.modmenu.gui;

import io.github.prospector.modmenu.ModMenu;
import io.github.prospector.modmenu.config.ModMenuConfigManager;
import io.github.prospector.modmenu.gui.AlwaysSelectedEntryListWidget;
import io.github.prospector.modmenu.gui.ModListEntry;
import io.github.prospector.modmenu.gui.ModListScreen;
import io.github.prospector.modmenu.gui.entries.ChildEntry;
import io.github.prospector.modmenu.gui.entries.IndependentEntry;
import io.github.prospector.modmenu.gui.entries.ParentEntry;
import io.github.prospector.modmenu.util.ModListSearch;
import java.awt.image.BufferedImage;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_189;
import net.minecraft.class_67;
import net.minecraft.client.Minecraft;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

public class ModListWidget
extends AlwaysSelectedEntryListWidget<ModListEntry>
implements AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<Path, BufferedImage> modIconsCache = new HashMap<Path, BufferedImage>();
    private final ModListScreen parent;
    private List<ModContainer> modContainerList = null;
    private Set<ModContainer> addedMods = new HashSet<ModContainer>();
    private String selectedModId = null;
    private boolean scrolling;
    private boolean isFocused;

    public ModListWidget(Minecraft client, int width, int height, int y1, int y2, int entryHeight, String searchTerm, ModListWidget list, ModListScreen parent) {
        super(client, width, height, y1, y2, entryHeight);
        this.parent = parent;
        if (list != null) {
            this.modContainerList = list.modContainerList;
        }
        this.filter(searchTerm, false);
        this.setScrollAmount(parent.getScrollPercent() * (double)Math.max(0, this.getMaxPosition() - (this.bottom - this.top - 4)));
    }

    @Override
    public void setScrollAmount(double amount) {
        super.setScrollAmount(amount);
        int denominator = Math.max(0, this.getMaxPosition() - (this.bottom - this.top - 4));
        if (denominator <= 0) {
            this.parent.updateScrollPercent(0.0);
        } else {
            this.parent.updateScrollPercent(this.getScrollAmount() / (double)Math.max(0, this.getMaxPosition() - (this.bottom - this.top - 4)));
        }
    }

    @Override
    protected boolean isFocused() {
        return this.isFocused;
    }

    public void select(ModListEntry entry) {
        this.setSelected(entry);
    }

    @Override
    public void setSelected(ModListEntry entry) {
        super.setSelected(entry);
        this.selectedModId = entry.getMetadata().getId();
        this.parent.updateSelectedEntry((ModListEntry)((Object)this.getSelected()));
    }

    @Override
    protected boolean isSelectedItem(int index) {
        ModListEntry selected = (ModListEntry)((Object)this.getSelected());
        return selected != null && selected.getMetadata().getId().equals(((ModListEntry)((Object)this.getEntry(index))).getMetadata().getId());
    }

    @Override
    public int addEntry(ModListEntry entry) {
        if (this.addedMods.contains(entry.container)) {
            return 0;
        }
        this.addedMods.add(entry.container);
        int i = super.addEntry(entry);
        if (entry.getMetadata().getId().equals(this.selectedModId)) {
            this.setSelected(entry);
        }
        return i;
    }

    @Override
    protected boolean removeEntry(ModListEntry entry) {
        this.addedMods.remove(entry.container);
        return super.removeEntry(entry);
    }

    @Override
    protected ModListEntry remove(int index) {
        this.addedMods.remove(((ModListEntry)((Object)this.getEntry((int)index))).container);
        return (ModListEntry)((Object)super.remove(index));
    }

    public void reloadFilters() {
        this.filter(this.parent.getSearchInput(), true, false);
    }

    public void filter(String searchTerm, boolean refresh) {
        this.filter(searchTerm, refresh, true);
    }

    private void filter(String searchTerm, boolean refresh, boolean search) {
        this.clearEntries();
        this.addedMods.clear();
        Collection mods = FabricLoader.getInstance().getAllMods();
        if (this.modContainerList == null || refresh) {
            this.modContainerList = new ArrayList<ModContainer>();
            this.modContainerList.addAll(mods);
            this.modContainerList.sort(ModMenuConfigManager.getConfig().getSorting().getComparator());
        }
        boolean validSearch = ModListSearch.validSearchQuery(searchTerm);
        List<ModContainer> matched = ModListSearch.search(this.parent, searchTerm, this.modContainerList);
        for (ModContainer container : matched) {
            ModMetadata metadata = container.getMetadata();
            String modId = metadata.getId();
            boolean library = ModMenu.LIBRARY_MODS.contains(modId);
            if (library && !ModMenuConfigManager.getConfig().showLibraries() || ModMenu.PARENT_MAP.values().contains(container)) continue;
            if (ModMenu.PARENT_MAP.keySet().contains(container)) {
                List children = ModMenu.PARENT_MAP.get((Object)container);
                children.sort(ModMenuConfigManager.getConfig().getSorting().getComparator());
                ParentEntry parent = new ParentEntry(this.minecraft, container, children, this);
                this.addEntry(parent);
                if (!this.parent.showModChildren.contains(modId)) continue;
                List<ModContainer> validChildren = ModListSearch.search(this.parent, searchTerm, children);
                for (ModContainer child : validChildren) {
                    this.addEntry(new ChildEntry(this.minecraft, child, parent, this, validChildren.indexOf(child) == validChildren.size() - 1));
                }
                continue;
            }
            this.addEntry(new IndependentEntry(this.minecraft, container, this));
        }
        if (this.parent.getSelectedEntry() != null && !this.children().isEmpty() || this.getSelected() != null && ((ModListEntry)((Object)this.getSelected())).getMetadata() != this.parent.getSelectedEntry().getMetadata()) {
            for (ModListEntry entry : this.children()) {
                if (!entry.getMetadata().equals(this.parent.getSelectedEntry().getMetadata())) continue;
                this.setSelected(entry);
            }
        } else if (this.getSelected() == null && !this.children().isEmpty() && this.getEntry(0) != null) {
            this.setSelected((ModListEntry)((Object)this.getEntry(0)));
        }
        if (this.getScrollAmount() > (double)Math.max(0, this.getMaxPosition() - (this.bottom - this.top - 4))) {
            this.setScrollAmount(Math.max(0, this.getMaxPosition() - (this.bottom - this.top - 4)));
        }
    }

    @Override
    protected void renderList(int x, int y, int mouseX, int mouseY, float delta) {
        int itemCount = this.getItemCount();
        class_67 tessellator_1 = class_67.field_2054;
        for (int index = 0; index < itemCount; ++index) {
            int entryLeft;
            int entryTop = this.getRowTop(index) + 2;
            int entryBottom = this.getRowTop(index) + this.itemHeight;
            if (entryBottom < this.top || entryTop > this.bottom) continue;
            int entryHeight = this.itemHeight - 4;
            ModListEntry entry = (ModListEntry)((Object)this.getEntry(index));
            int rowWidth = this.getRowWidth();
            if (this.renderSelection && this.isSelectedItem(index)) {
                entryLeft = this.getRowLeft() - 2 + entry.getXOffset();
                int selectionRight = x + rowWidth + 2;
                GL11.glDisable((int)3553);
                float float_2 = this.isFocused() ? 1.0f : 0.5f;
                GL11.glColor4f((float)float_2, (float)float_2, (float)float_2, (float)1.0f);
                tessellator_1.method_1695();
                tessellator_1.method_1687((double)entryLeft, (double)(entryTop + entryHeight + 2), 0.0);
                tessellator_1.method_1687((double)selectionRight, (double)(entryTop + entryHeight + 2), 0.0);
                tessellator_1.method_1687((double)selectionRight, (double)(entryTop - 2), 0.0);
                tessellator_1.method_1687((double)entryLeft, (double)(entryTop - 2), 0.0);
                tessellator_1.method_1685();
                GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                tessellator_1.method_1695();
                tessellator_1.method_1687((double)(entryLeft + 1), (double)(entryTop + entryHeight + 1), 0.0);
                tessellator_1.method_1687((double)(selectionRight - 1), (double)(entryTop + entryHeight + 1), 0.0);
                tessellator_1.method_1687((double)(selectionRight - 1), (double)(entryTop - 1), 0.0);
                tessellator_1.method_1687((double)(entryLeft + 1), (double)(entryTop - 1), 0.0);
                tessellator_1.method_1685();
                GL11.glEnable((int)3553);
            }
            entryLeft = this.getRowLeft();
            entry.render(index, entryTop, entryLeft, rowWidth, entryHeight, mouseX, mouseY, this.isMouseOver(mouseX, mouseY) && Objects.equals((Object)this.getEntryAtPos(mouseX, mouseY), (Object)entry), delta);
        }
    }

    @Override
    protected void updateScrollingState(double double_1, double double_2, int int_1) {
        super.updateScrollingState(double_1, double_2, int_1);
        this.scrolling = int_1 == 0 && double_1 >= (double)this.getScrollbarPosition() && double_1 < (double)(this.getScrollbarPosition() + 6);
    }

    @Override
    public boolean mouseClicked(double double_1, double double_2, int int_1) {
        this.updateScrollingState(double_1, double_2, int_1);
        if (!this.isMouseOver(double_1, double_2)) {
            return false;
        }
        ModListEntry entry = this.getEntryAtPos(double_1, double_2);
        if (entry != null) {
            if (entry.mouseClicked(double_1, double_2, int_1)) {
                this.setFocused(entry);
                this.setDragging(true);
                return true;
            }
        } else if (int_1 == 0) {
            this.clickedHeader((int)(double_1 - (double)(this.left + this.width / 2 - this.getRowWidth() / 2)), (int)(double_2 - (double)this.top) + (int)this.getScrollAmount() - 4);
            return true;
        }
        return this.scrolling;
    }

    public final ModListEntry getEntryAtPos(double x, double y) {
        int int_5 = class_189.method_645((double)(y - (double)this.top)) - this.headerHeight + (int)this.getScrollAmount() - 4;
        int index = int_5 / this.itemHeight;
        return x < (double)this.getScrollbarPosition() && x >= (double)this.getRowLeft() && x <= (double)(this.getRowLeft() + this.getRowWidth()) && index >= 0 && int_5 >= 0 && index < this.getItemCount() ? (ModListEntry)((Object)this.children().get(index)) : null;
    }

    @Override
    protected int getScrollbarPosition() {
        return this.width - 6;
    }

    @Override
    public int getRowWidth() {
        return this.width - (Math.max(0, this.getMaxPosition() - (this.bottom - this.top - 4)) > 0 ? 18 : 12);
    }

    @Override
    protected int getRowLeft() {
        return this.left + 6;
    }

    public int getWidth() {
        return this.width;
    }

    public int getTop() {
        return this.top;
    }

    public ModListScreen getParent() {
        return this.parent;
    }

    @Override
    protected int getMaxPosition() {
        return super.getMaxPosition() + 4;
    }

    public int getDisplayedCount() {
        return this.children().size();
    }

    @Override
    public void close() {
        this.children().forEach(ModListEntry::deleteTexture);
    }

    BufferedImage getCachedModIcon(Path path) {
        return this.modIconsCache.get(path);
    }

    void cacheModIcon(Path path, BufferedImage tex) {
        this.modIconsCache.put(path, tex);
    }

    public Set<ModContainer> getCurrentModSet() {
        return this.addedMods;
    }
}

