package net.glasslauncher.mods.networking;

import com.google.common.hash.Hashing;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.glasslauncher.mods.networking.helpers.PacketHelperClientImpl;
import net.glasslauncher.mods.networking.helpers.PacketHelperImpl;
import net.glasslauncher.mods.networking.helpers.PacketHelperServerImpl;
import net.minecraft.class_187;
import net.minecraft.class_219;
import net.minecraft.class_240;
import net.minecraft.class_54;
import net.minecraft.class_69;
import net.minecraft.client.Minecraft;
import java.io.*;
import java.util.*;
import java.util.function.*;

public class GlassNetworking implements ModInitializer {
    public static final long MASK = Hashing.sipHash24().hashUnencodedChars("glassnetworking").asLong();
    public static final int PACKET_ID = 253; // StAPI uses 254, and 255 is the disconnect packet

    private static final PacketHelperImpl PACKET_HELPER = FabricLoader.getInstance().getEnvironmentType().equals(EnvType.CLIENT) ? new PacketHelperClientImpl() : new PacketHelperServerImpl();

    static final ArrayList<String> SERVER_BOUND_PACKETS = new ArrayList<>();
    static final ArrayList<String> CLIENT_BOUND_PACKETS = new ArrayList<>();
    static final HashMap<String, BiConsumer<GlassPacket, class_240>> PACKET_LISTENERS = new HashMap<>();

    public static int writeAndGetNbtLength(class_187 element, OutputStream dataOutput) {
        DataOutputStream outputStream = new DataOutputStream(dataOutput);
        element.method_631(outputStream);
        try {
            outputStream.flush();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return outputStream.size();
    }

    public static boolean isClientPacket(String fullId) {
        return CLIENT_BOUND_PACKETS.contains(fullId);
    }

    public static boolean isServerPacket(String fullId) {
        return SERVER_BOUND_PACKETS.contains(fullId);
    }

    /**
     * If this is called on server, the packet will be applied as if the server just got the packet from a client.
     * If this is called on a client that's in singleplayer, the client will apply the packet as if it was the server.
     */
    public static void sendToServer(GlassPacket packet) {
        PACKET_HELPER.send(packet);
    }

    /**
     * If this is called in client, it will treat the packet as if it got it from a server.
     */
    public static void sendToPlayer(class_54 player, GlassPacket packet) {
        PACKET_HELPER.sendTo(player, packet);
    }

    @Override
    public void onInitialize() {
        FabricLoader.getInstance().getEntrypoints("glassnetworking", GlassPacketListener.class).forEach(GlassPacketListener::registerGlassPackets);
    }

    @Environment(EnvType.CLIENT)
    public static boolean serverHasNetworking() {
        class_219 handler = Minecraft.field_2791.method_2145();
        if (handler == null) {
            return false;
        }

        return ((GlassNetworkHandler) handler).glass_Networking$hasGlassNetworking();
    }

    @Environment(EnvType.SERVER)
    public static boolean clientHasNetworking(class_69 entity) {
        return ((GlassNetworkHandler) entity.field_255).glass_Networking$hasGlassNetworking();
    }
}
