package net.glasslauncher.mods.networking;

import lombok.Getter;
import net.minecraft.class_169;
import net.minecraft.class_240;
import net.minecraft.class_8;
import org.jetbrains.annotations.ApiStatus;

import java.io.*;

public class GlassPacket extends class_169 {
    private @Getter String modId;
    private @Getter String packetId;
    private @Getter class_8 nbt;

    private int length;

    /***
     * Use this when sending the packet.
     */
    public <T extends GlassPacket> GlassPacket(String modId, String packetId, class_8 nbt) {
        this.modId = modId;
        this.packetId = packetId;
        this.nbt = nbt;
    }

    /**
     * Don't use. Internal IMPL constructor.
     */
    @ApiStatus.Internal
    public GlassPacket() {}

    @Override
    public void method_806(DataInputStream stream) {
        nbt = new class_8();
        nbt.method_630(stream);
        packetId = nbt.method_1031("glassnetworking:packetId");
        modId = nbt.method_1031("glassnetworking:modId");
    }

    @Override
    public void method_807(DataOutputStream stream) {
        nbt.method_1019("glassnetworking:packetId", packetId);
        nbt.method_1019("glassnetworking:modId", modId);
        length = GlassNetworking.writeAndGetNbtLength(nbt, stream);
    }

    @Override
    public void method_808(class_240 networkHandler) {
        GlassNetworking.PACKET_LISTENERS.get(getFullId()).accept(this, networkHandler);
    }

    @Override
    public int method_798() {
        return length;
    }

    public String getFullId() {
        return modId + ":" + packetId;
    }
}
