/*
 * Decompiled with CFR 0.152.
 */
package net.mine_diver.unsafeevents;

import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.ToIntFunction;
import net.mine_diver.unsafeevents.event.Cancelable;
import net.mine_diver.unsafeevents.util.UnsafeProvider;
import net.mine_diver.unsafeevents.util.Util;
import org.jetbrains.annotations.NotNull;

public abstract class Event {
    @NotNull
    private static final AtomicInteger INTERNAL_NEXT_ID;
    @Deprecated(forRemoval=true)
    @NotNull
    protected static final AtomicInteger NEXT_ID;
    @NotNull
    private static final @NotNull Reference2IntMap<@NotNull Class<? extends Event>> EVENT_ID_LOOKUP;
    @NotNull
    private static final @NotNull ToIntFunction<@NotNull Class<? extends Event>> ID_GETTER;
    @NotNull
    private static final @NotNull ToIntFunction<@NotNull Class<? extends Event>> ID_GENERATOR;
    @NotNull
    private final AtomicBoolean canceled = new AtomicBoolean();

    public static <EVENT extends Event> int getEventID(@NotNull Class<EVENT> eventType) {
        int eventId = EVENT_ID_LOOKUP.getInt(eventType);
        if (eventId > -1) {
            return eventId;
        }
        try {
            MethodHandles.lookup().ensureInitialized(eventType);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        int clinitId = EVENT_ID_LOOKUP.getInt(eventType);
        if (clinitId > -1) {
            return clinitId;
        }
        int extractedId = ID_GETTER.applyAsInt(eventType);
        EVENT_ID_LOOKUP.put(eventType, extractedId);
        return extractedId;
    }

    protected static int nextID() {
        Class<?> callerClass = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass();
        if (!Event.class.isAssignableFrom(callerClass)) {
            throw new IllegalCallerException();
        }
        return EVENT_ID_LOOKUP.computeIfAbsent(callerClass.asSubclass(Event.class), ID_GENERATOR);
    }

    public boolean isCancelable() {
        return this.getClass().isAnnotationPresent(Cancelable.class);
    }

    public boolean isCanceled() {
        return this.canceled.get();
    }

    public void setCanceled(boolean canceled) {
        if (!this.isCancelable()) {
            throw new UnsupportedOperationException(String.format("Trying to cancel a not cancellable event! (%s)", this.getClass().getName()));
        }
        this.canceled.set(canceled);
    }

    public final void cancel() {
        this.setCanceled(true);
    }

    public final void resume() {
        this.setCanceled(false);
    }

    protected void finish() {
    }

    protected int getEventID() {
        return EVENT_ID_LOOKUP.computeIfAbsent(this.getClass(), ID_GENERATOR);
    }

    protected Event(EventBuilder<?, ?> b) {
    }

    protected Event() {
    }

    static {
        NEXT_ID = INTERNAL_NEXT_ID = new AtomicInteger();
        EVENT_ID_LOOKUP = (Reference2IntMap)Util.make(new Reference2IntOpenHashMap(), map -> map.defaultReturnValue(-1));
        ID_GETTER = eventType -> {
            try {
                return ((Event)UnsafeProvider.theUnsafe.allocateInstance((Class<?>)eventType)).getEventID();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
        };
        ID_GENERATOR = eventType -> INTERNAL_NEXT_ID.incrementAndGet();
    }

    public static abstract class EventBuilder<C extends Event, B extends EventBuilder<C, B>> {
        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "Event.EventBuilder()";
        }
    }
}

