/*
 * Decompiled with CFR 0.152.
 */
package net.mine_diver.unsafeevents;

import com.google.common.collect.ObjectArrays;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.function.Consumer;
import net.mine_diver.unsafeevents.DeadEvent;
import net.mine_diver.unsafeevents.Event;
import net.mine_diver.unsafeevents.ListenerRegistryFactory;
import net.mine_diver.unsafeevents.MutableEventBus;
import net.mine_diver.unsafeevents.event.PhaseOrdering;
import net.mine_diver.unsafeevents.event.PhaseOrderingInvalidationCallback;
import net.mine_diver.unsafeevents.listener.Listener;
import net.mine_diver.unsafeevents.listener.SingularListener;
import net.mine_diver.unsafeevents.util.Util;
import net.mine_diver.unsafeevents.util.collection.Int2ReferenceArrayMapWrapper;
import net.mine_diver.unsafeevents.util.exception.DispatchException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventBus
implements MutableEventBus,
PhaseOrderingInvalidationCallback {
    @NotNull
    protected static final @NotNull Consumer<@NotNull Event> DEAD_EVENT_FALLBACK = event -> {};
    @NotNull
    protected final @NotNull Consumer<@NotNull Event> DEAD_EVENT = event -> {
        DeadEvent deadEvent = DeadEvent.INSTANCE;
        deadEvent.event = event;
        this.post(deadEvent);
    };
    @NotNull
    protected final @NotNull Reference2ReferenceMap<Class<? extends Event>, @NotNull SingularListener<?> @NotNull []> listeners = new Reference2ReferenceOpenHashMap();
    @NotNull
    protected @NotNull Consumer<? extends @NotNull Event> @NotNull [] registriesArray = new Consumer[0];
    @NotNull
    protected final @NotNull Int2ReferenceArrayMapWrapper<@NotNull Consumer<? extends @NotNull Event>> registries = Util.make(new Int2ReferenceArrayMapWrapper<Consumer<Event>>(() -> this.registriesArray, arr -> {
        this.registriesArray = arr;
    }, Consumer[]::new, this.DEAD_EVENT, DeadEvent.ID + 1), wrapper -> wrapper.put(DeadEvent.ID, DEAD_EVENT_FALLBACK));
    @NotNull
    protected final ReferenceSet<Class<? extends Event>> invalidatedRegistries = new ReferenceOpenHashSet();
    protected boolean invalidated;

    public EventBus() {
        PhaseOrdering.addInvalidationCallback(this);
    }

    @Override
    public <EVENT extends Event> void register(@NotNull @NotNull SingularListener<@NotNull EVENT> listener) {
        Class<EVENT> eventType = listener.eventType();
        this.listeners.compute(eventType, (id, containers) -> {
            SingularListener[] singularListenerArray;
            if (containers == null) {
                SingularListener[] singularListenerArray2 = new SingularListener[1];
                singularListenerArray = singularListenerArray2;
                singularListenerArray2[0] = listener;
            } else {
                singularListenerArray = (SingularListener[])ObjectArrays.concat((Object[])containers, (Object)listener);
            }
            return singularListenerArray;
        });
        this.invalidatedRegistries.add(eventType);
        this.invalidated = true;
    }

    @Override
    public <EVENT extends Event> void unregister(@NotNull @NotNull SingularListener<@NotNull EVENT> listener) {
        Class<EVENT> eventType = listener.eventType();
        this.listeners.compute(eventType, (id, eventListeners) -> {
            if (eventListeners != null) {
                int indexToRemove = -1;
                for (int i = 0; i < ((SingularListener[])eventListeners).length; ++i) {
                    if (eventListeners[i] != listener) continue;
                    indexToRemove = i;
                    break;
                }
                if (indexToRemove > -1) {
                    SingularListener[] newArray = new SingularListener[((SingularListener[])eventListeners).length - 1];
                    System.arraycopy(eventListeners, 0, newArray, 0, indexToRemove);
                    System.arraycopy(eventListeners, indexToRemove + 1, newArray, indexToRemove, ((SingularListener[])eventListeners).length - indexToRemove - 1);
                    return newArray;
                }
            }
            throw new IllegalArgumentException("The event bus doesn't contain this listener!");
        });
        this.invalidatedRegistries.add(eventType);
        this.invalidated = true;
    }

    protected void compileRegistries() {
        this.invalidatedRegistries.iterator().forEachRemaining(this::compileRegistry);
        this.invalidatedRegistries.clear();
        this.invalidated = false;
    }

    private <EVENT extends Event> void compileRegistry(Class<EVENT> eventType) {
        SingularListener[] listenerContainers = (SingularListener[])this.listeners.get(eventType);
        Arrays.sort(listenerContainers, PhaseOrdering.of(eventType).getListenerComparator());
        this.registries.put(Event.getEventID(eventType), listenerContainers.length == 1 ? listenerContainers[0].listener() : ListenerRegistryFactory.create((Consumer[])Arrays.stream(listenerContainers).map(SingularListener::listener).toArray(Consumer[]::new)));
    }

    @Override
    @ApiStatus.Internal
    public <EVENT extends Event> void phaseOrderingInvalidated(PhaseOrdering<EVENT> ordering) {
        if (this.listeners.containsKey(ordering.eventType)) {
            this.invalidatedRegistries.add(ordering.eventType);
            this.invalidated = true;
        }
    }

    @Override
    @Contract(value="_ -> param1")
    @CanIgnoreReturnValue
    @NotNull
    public <EVENT extends Event> EVENT post(@NotNull EVENT event) {
        int eventId;
        if (this.invalidated) {
            this.compileRegistries();
        }
        if ((eventId = event.getEventID()) >= this.registriesArray.length) {
            this.registries.resizeArray(eventId + 1);
        }
        try {
            this.registriesArray[eventId].accept(event);
        }
        catch (Throwable throwable) {
            throw new DispatchException(String.format("An exception occurred during a dispatch of %s to %s", event, this), throwable);
        }
        return MutableEventBus.super.post(event);
    }

    @Deprecated
    public void register(@NotNull Class<?> listenerClass) {
        this.register(Listener.staticMethods().listener(listenerClass).build());
    }

    @Deprecated
    public void register(@NotNull Object listener) {
        this.register(Listener.object().listener(listener).build());
    }

    @Deprecated
    public <T, U extends T> void register(@NotNull Class<? super U> listenerClass, @Nullable T listener) {
        this.register(listener == null ? Listener.staticMethods().listener(listenerClass).build() : Listener.object().listener(listener).build());
    }

    @Deprecated
    public void register(@NotNull Method method) {
        this.register(Listener.reflection().method(method).build());
    }

    @Deprecated
    public void register(@NotNull Method method, int priority) {
        this.register(Listener.reflection().method(method).priority(priority).build());
    }

    @Deprecated
    public void register(@NotNull Method method, @Nullable Object listener) {
        this.register(Listener.reflection().method(method).listener(listener).build());
    }

    @Deprecated
    public <EVENT extends Event> void register(@NotNull Method method, @Nullable Object listener, int priority) {
        this.register(Listener.reflection().method(method).listener(listener).priority(priority).build());
    }

    @Deprecated
    public <EVENT extends Event> void register(@NotNull @NotNull Consumer<@NotNull EVENT> listener) {
        this.register(Listener.simple().listener(listener).build());
    }

    @Deprecated
    public <EVENT extends Event> void register(@NotNull @NotNull Consumer<@NotNull EVENT> listener, int priority) {
        this.register(Listener.simple().listener(listener).priority(priority).build());
    }

    @Deprecated
    public <EVENT extends Event> void register(@NotNull Class<EVENT> eventType, @NotNull @NotNull Consumer<@NotNull EVENT> listener) {
        this.register(Listener.simple().eventType(eventType).listener(listener).build());
    }

    @Deprecated
    public <EVENT extends Event> void register(@NotNull Class<EVENT> eventType, @NotNull @NotNull Consumer<@NotNull EVENT> listener, int priority) {
        this.register(Listener.simple().eventType(eventType).listener(listener).priority(priority).build());
    }
}

