/*
 * Decompiled with CFR 0.152.
 */
package net.mine_diver.unsafeevents.event;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.mine_diver.unsafeevents.Event;
import net.mine_diver.unsafeevents.event.EventPhaseData;
import net.mine_diver.unsafeevents.event.EventPhases;
import net.mine_diver.unsafeevents.event.PhaseOrderingInvalidationCallback;
import net.mine_diver.unsafeevents.event.PhaseSorting;
import net.mine_diver.unsafeevents.listener.GenericListener;
import net.mine_diver.unsafeevents.listener.SingularListener;
import net.mine_diver.unsafeevents.util.Util;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhaseOrdering<EVENT extends Event> {
    @NotNull
    private static final @NotNull Reference2ReferenceMap<@NotNull Class<? extends Event>, @NotNull PhaseOrdering<?>> PHASE_ORDERING_STORAGE = new Reference2ReferenceOpenHashMap();
    @NotNull
    private static final @NotNull Function<@NotNull Class<? extends Event>, @NotNull PhaseOrdering<? extends Event>> PHASE_ORDERING_GENERATOR = PhaseOrdering::new;
    private static final Set<PhaseOrderingInvalidationCallback> INVALIDATION_LISTENERS = Util.newWeakSet();
    public final Class<EVENT> eventType;
    private final Object2ReferenceMap<@NotNull String, @Nullable EventPhaseData> phases = new Object2ReferenceOpenHashMap();
    private final List<@NotNull EventPhaseData> sortedPhases = new ReferenceArrayList();
    private Comparator<SingularListener<?>> listenerComparator;
    private final Consumer<PhaseOrderingInvalidationCallback> invalidationCallbackInvoker = callback -> callback.phaseOrderingInvalidated(this);

    public static <EVENT extends Event> PhaseOrdering<EVENT> of(@NotNull Class<EVENT> eventType) {
        return (PhaseOrdering)PHASE_ORDERING_STORAGE.computeIfAbsent(eventType, PHASE_ORDERING_GENERATOR);
    }

    public static void addInvalidationCallback(PhaseOrderingInvalidationCallback listener) {
        INVALIDATION_LISTENERS.add(listener);
    }

    private static Comparator<SingularListener<?>> bakeComparator(@NotNull @NotNull List<@NotNull EventPhaseData> sortedPhases) {
        ImmutableList immutablePhases = (ImmutableList)sortedPhases.stream().map(eventPhaseData -> eventPhaseData.id).collect(ImmutableList.toImmutableList());
        return Comparator.comparing(GenericListener::phase, Comparator.comparingInt(object -> {
            int index = immutablePhases.indexOf(object);
            return index < 0 ? Integer.MAX_VALUE : index;
        })).thenComparing(Comparator.comparingInt(GenericListener::priority).reversed());
    }

    private PhaseOrdering(@NotNull Class<EVENT> eventType) {
        this.eventType = eventType;
        boolean noDefault = true;
        @Nullable String prevPhase = null;
        if (eventType.isAnnotationPresent(EventPhases.class)) {
            for (String phase : eventType.getAnnotation(EventPhases.class).value()) {
                if (noDefault && "default".equals(phase)) {
                    noDefault = false;
                }
                if (prevPhase == null) {
                    this.getOrCreatePhase(phase);
                } else {
                    this.addPhaseOrdering(prevPhase, phase);
                }
                prevPhase = phase;
            }
        }
        if (noDefault) {
            if (prevPhase == null) {
                this.getOrCreatePhase("default");
            } else {
                this.addPhaseOrdering(prevPhase, "default");
            }
        }
    }

    public Comparator<SingularListener<?>> getListenerComparator() {
        return Objects.requireNonNullElseGet(this.listenerComparator, () -> {
            this.listenerComparator = PhaseOrdering.bakeComparator(this.sortedPhases);
            return this.listenerComparator;
        });
    }

    private EventPhaseData getOrCreatePhase(@NotNull String id) {
        EventPhaseData phase = (EventPhaseData)this.phases.get((Object)id);
        if (phase == null) {
            phase = new EventPhaseData(id);
            this.phases.put((Object)id, (Object)phase);
            this.sortedPhases.add(phase);
            this.listenerComparator = null;
        }
        return phase;
    }

    public void addPhaseOrdering(@NotNull String firstPhase, @NotNull String secondPhase) {
        Objects.requireNonNull(firstPhase, "Tried to add an ordering for a null phase.");
        Objects.requireNonNull(secondPhase, "Tried to add an ordering for a null phase.");
        if (firstPhase.equals(secondPhase)) {
            throw new IllegalArgumentException("Tried to add a phase that depends on itself.");
        }
        EventPhaseData first = this.getOrCreatePhase(firstPhase);
        EventPhaseData second = this.getOrCreatePhase(secondPhase);
        first.subsequentPhases.add(second);
        second.previousPhases.add(first);
        PhaseSorting.sortPhases(this.sortedPhases);
        this.listenerComparator = null;
        INVALIDATION_LISTENERS.forEach(this.invalidationCallbackInvoker);
    }
}

