/*
 * Decompiled with CFR 0.152.
 */
package net.mine_diver.unsafeevents.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import net.mine_diver.unsafeevents.event.EventPhaseData;

class PhaseSorting {
    PhaseSorting() {
    }

    static void sortPhases(List<EventPhaseData> sortedPhases) {
        ArrayList<EventPhaseData> toposort = new ArrayList<EventPhaseData>(sortedPhases.size());
        for (EventPhaseData eventPhaseData : sortedPhases) {
            PhaseSorting.forwardVisit(eventPhaseData, null, toposort);
        }
        PhaseSorting.clearStatus(toposort);
        Collections.reverse(toposort);
        IdentityHashMap<EventPhaseData, PhaseScc> phaseToScc = new IdentityHashMap<EventPhaseData, PhaseScc>();
        for (EventPhaseData phase : toposort) {
            if (phase.visitStatus != 0) continue;
            ArrayList<EventPhaseData> sccPhases = new ArrayList<EventPhaseData>();
            PhaseSorting.backwardVisit(phase, sccPhases);
            sccPhases.sort(Comparator.comparing(p -> p.id));
            PhaseScc scc2 = new PhaseScc((List<EventPhaseData>)sccPhases);
            Iterator<Object> iterator = sccPhases.iterator();
            while (iterator.hasNext()) {
                EventPhaseData phaseInScc = (EventPhaseData)iterator.next();
                phaseToScc.put(phaseInScc, scc2);
            }
        }
        PhaseSorting.clearStatus(toposort);
        for (Object scc3 : phaseToScc.values()) {
            for (EventPhaseData phase : ((PhaseScc)scc3).phases) {
                for (EventPhaseData subsequentPhase : phase.subsequentPhases) {
                    PhaseScc subsequentScc = (PhaseScc)phaseToScc.get(subsequentPhase);
                    if (subsequentScc == scc3) continue;
                    ((PhaseScc)scc3).subsequentSccs.add(subsequentScc);
                    ++subsequentScc.inDegree;
                }
            }
        }
        PriorityQueue<PhaseScc> priorityQueue = new PriorityQueue<PhaseScc>(Comparator.comparing(scc -> scc.phases.get((int)0).id));
        sortedPhases.clear();
        for (PhaseScc scc4 : phaseToScc.values()) {
            if (scc4.inDegree != 0) continue;
            priorityQueue.add(scc4);
            scc4.inDegree = -1;
        }
        while (!priorityQueue.isEmpty()) {
            PhaseScc scc2 = priorityQueue.poll();
            sortedPhases.addAll(scc2.phases);
            for (PhaseScc subsequentScc : scc2.subsequentSccs) {
                --subsequentScc.inDegree;
                if (subsequentScc.inDegree != 0) continue;
                priorityQueue.add(subsequentScc);
            }
        }
    }

    private static void forwardVisit(EventPhaseData phase, EventPhaseData parent, List<EventPhaseData> toposort) {
        if (phase.visitStatus == 0) {
            phase.visitStatus = 1;
            for (EventPhaseData data : phase.subsequentPhases) {
                PhaseSorting.forwardVisit(data, phase, toposort);
            }
            toposort.add(phase);
            phase.visitStatus = 2;
        } else if (phase.visitStatus == 1) {
            throw new IllegalStateException(String.format("Event phase ordering conflict detected.%nEvent phase %s is ordered both before and after event phase %s.", phase.id, parent.id));
        }
    }

    private static void clearStatus(List<EventPhaseData> phases) {
        for (EventPhaseData phase : phases) {
            phase.visitStatus = 0;
        }
    }

    private static void backwardVisit(EventPhaseData phase, List<EventPhaseData> sccPhases) {
        if (phase.visitStatus == 0) {
            phase.visitStatus = 1;
            sccPhases.add(phase);
            for (EventPhaseData data : phase.previousPhases) {
                PhaseSorting.backwardVisit(data, sccPhases);
            }
        }
    }

    private static class PhaseScc {
        final List<EventPhaseData> phases;
        final List<PhaseScc> subsequentSccs = new ArrayList<PhaseScc>();
        int inDegree = 0;

        private PhaseScc(List<EventPhaseData> phases) {
            this.phases = phases;
        }
    }
}

