/*
 * Decompiled with CFR 0.152.
 */
package net.mine_diver.unsafeevents.eventbus;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import net.mine_diver.unsafeevents.Event;
import net.mine_diver.unsafeevents.EventBus;
import net.mine_diver.unsafeevents.util.exception.DisabledDispatchCause;
import net.mine_diver.unsafeevents.util.exception.IllegalDispatchException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ManagedEventBus
extends EventBus {
    protected boolean dispatchDisabled;
    protected DisabledDispatchCause disabledDispatchCause;

    public void disableDispatch(@NotNull String reason) {
        this.dispatchDisabled = true;
        this.disabledDispatchCause = new DisabledDispatchCause(reason);
    }

    public void enableDispatch() {
        this.dispatchDisabled = false;
        this.disabledDispatchCause = null;
    }

    @Override
    @Contract(value="_ -> param1")
    @CanIgnoreReturnValue
    @NotNull
    public <EVENT extends Event> EVENT post(@NotNull EVENT event) {
        if (this.dispatchDisabled) {
            throw new IllegalDispatchException(String.format("Attempted to dispatch event %s when dispatch is disabled!", event.getClass().getName()), this.disabledDispatchCause);
        }
        return super.post(event);
    }
}

