/*
 * Decompiled with CFR 0.152.
 */
package net.mine_diver.unsafeevents.listener;

import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Objects;
import java.util.function.UnaryOperator;
import net.mine_diver.unsafeevents.listener.ListenerPriority;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Target(value={ElementType.TYPE, ElementType.METHOD})
@Inherited
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
public @interface EventListener {
    public static final int DEFAULT_PRIORITY = 0;

    public String phase() default "default";

    public ListenerPriority priority() default ListenerPriority.CUSTOM;

    public int numPriority() default 0;

    public static final class Helper {
        private Helper() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }

        @NotNull
        public static String getPhase(@NotNull EventListener listener) {
            return Helper.getPhase(listener, UnaryOperator.identity());
        }

        @NotNull
        public static String getPhase(@NotNull EventListener listener, @Nullable String customDefault) {
            return Helper.getPhase(listener, defaultPhase -> Objects.requireNonNullElse(customDefault, defaultPhase));
        }

        @NotNull
        public static String getPhase(@NotNull EventListener listener, @NotNull @NotNull UnaryOperator<@NotNull String> defaultOverride) {
            String listenerPhase = listener.phase();
            return "default".equals(listenerPhase) ? (String)defaultOverride.apply(listenerPhase) : listenerPhase;
        }

        public static int getPriority(@NotNull EventListener listener) {
            return Helper.getPriority(listener, Int2IntFunction.identity());
        }

        public static int getPriority(@NotNull EventListener listener, int customDefault) {
            return Helper.getPriority(listener, customPriority -> customPriority == 0 ? customDefault : customPriority);
        }

        public static int getPriority(@NotNull EventListener listener, @NotNull Int2IntFunction customOverride) {
            ListenerPriority listenerPriority = listener.priority();
            return listenerPriority.custom ? customOverride.get(listener.numPriority()) : listenerPriority.numPriority;
        }
    }
}

