/*
 * Decompiled with CFR 0.152.
 */
package net.mine_diver.unsafeevents.listener;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.function.Consumer;
import net.jodah.typetools.TypeResolver;
import net.mine_diver.unsafeevents.Event;
import net.mine_diver.unsafeevents.listener.CompositeListener;
import net.mine_diver.unsafeevents.listener.EventListener;
import net.mine_diver.unsafeevents.listener.ListenerExecutorFactory;
import net.mine_diver.unsafeevents.listener.SimpleCompositeListener;
import net.mine_diver.unsafeevents.listener.SimpleSingularListener;
import net.mine_diver.unsafeevents.listener.SingularListener;
import net.mine_diver.unsafeevents.util.exception.listener.IncompatibleEventTypesException;
import net.mine_diver.unsafeevents.util.exception.listener.InvalidMethodParameterCountException;
import net.mine_diver.unsafeevents.util.exception.listener.InvalidMethodParameterTypeException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Listener {
    @NotNull
    private static CompositeListener createStatic(@NotNull Class<?> listener, @Nullable String phase, int priority) {
        int defaultPriority;
        String defaultPhase;
        if (listener.isAnnotationPresent(EventListener.class)) {
            EventListener eventListener = listener.getAnnotation(EventListener.class);
            defaultPhase = EventListener.Helper.getPhase(eventListener, phase);
            defaultPriority = EventListener.Helper.getPriority(eventListener, priority);
        } else {
            defaultPhase = Objects.requireNonNullElse(phase, "default");
            defaultPriority = priority;
        }
        ImmutableList.Builder listeners = ImmutableList.builder();
        for (Method method : listener.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(EventListener.class) || !Modifier.isStatic(method.getModifiers())) continue;
            listeners.add(Listener.reflection().method(method).phase(defaultPhase).priority(defaultPriority).build());
        }
        return new SimpleCompositeListener(listeners.build(), defaultPhase, defaultPriority);
    }

    @NotNull
    private static <T> CompositeListener createObject(@NotNull T listener, @Nullable String phase, int priority) {
        Class listenerClass;
        Class curClass;
        ImmutableList.Builder listeners = ImmutableList.builder();
        ArrayDeque<Class> classDeque = new ArrayDeque<Class>();
        for (curClass = listenerClass = listener.getClass(); curClass != null; curClass = curClass.getSuperclass()) {
            classDeque.push(curClass);
        }
        String defaultPhase = "default";
        int defaultPriority = 0;
        while (!classDeque.isEmpty()) {
            curClass = (Class)classDeque.pop();
            @Nullable EventListener compositeListener = curClass.getAnnotation(EventListener.class);
            if (curClass == listenerClass) {
                if (compositeListener != null) {
                    defaultPhase = EventListener.Helper.getPhase(compositeListener, phase);
                    defaultPriority = EventListener.Helper.getPriority(compositeListener, priority);
                } else {
                    defaultPhase = Objects.requireNonNullElse(phase, "default");
                    defaultPriority = priority;
                }
            } else if (compositeListener != null) {
                defaultPhase = compositeListener.phase();
                defaultPriority = EventListener.Helper.getPriority(compositeListener);
            }
            for (Method method : curClass.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(EventListener.class) || Modifier.isStatic(method.getModifiers())) continue;
                listeners.add(Listener.reflection().listener(listener).method(method).phase(defaultPhase).priority(defaultPriority).build());
            }
        }
        return new SimpleCompositeListener(listeners.build(), defaultPhase, defaultPriority);
    }

    @NotNull
    private static <EVENT extends Event> @NotNull SingularListener<@NotNull EVENT> createReflection(@Nullable Class<EVENT> eventType, @Nullable Object listener, @NotNull Method method, @Nullable String phase, int priority) {
        int listenerPriority;
        String listenerPhase;
        if (method.getParameterCount() != 1) {
            throw new InvalidMethodParameterCountException(String.format("Method %s#%s has a wrong amount of parameters!", method.getDeclaringClass().getName(), method.getName()));
        }
        Class<EVENT> rawEventType = method.getParameterTypes()[0];
        if (eventType == null) {
            if (!Event.class.isAssignableFrom(rawEventType)) {
                throw new InvalidMethodParameterTypeException(String.format("Method %s#%s's parameter type (%s) is not an event!", method.getDeclaringClass().getName(), method.getName(), rawEventType.getName()));
            }
            eventType = rawEventType.asSubclass(Event.class);
        } else if (!rawEventType.isAssignableFrom(eventType)) {
            throw new IncompatibleEventTypesException(String.format("Method %s#%s's parameter type (%s) is not assignable from the passed event type (%s)!", method.getDeclaringClass().getName(), method.getName(), rawEventType.getName(), eventType.getName()));
        }
        if (method.isAnnotationPresent(EventListener.class)) {
            EventListener eventListener = method.getAnnotation(EventListener.class);
            listenerPhase = EventListener.Helper.getPhase(eventListener, phase);
            listenerPriority = EventListener.Helper.getPriority(eventListener, priority);
        } else {
            listenerPhase = Objects.requireNonNullElse(phase, "default");
            listenerPriority = priority;
        }
        return new SimpleSingularListener<EVENT>(eventType, ListenerExecutorFactory.create(listener, method, eventType), listenerPhase, listenerPriority);
    }

    @NotNull
    private static <EVENT extends Event> @NotNull SingularListener<@NotNull EVENT> createSimple(@Nullable Class<EVENT> eventType, @NotNull @NotNull Consumer<@NotNull EVENT> listener, @Nullable String phase, int priority) {
        Class<Event> rawEventType = TypeResolver.resolveRawArgument(Consumer.class, listener.getClass()).asSubclass(Event.class);
        if (eventType == null) {
            if (!Event.class.isAssignableFrom(rawEventType)) {
                throw new InvalidMethodParameterTypeException(String.format("Consumer %s's parameter type (%s) is not an event!", listener.getClass().getName(), rawEventType.getName()));
            }
            eventType = rawEventType.asSubclass(Event.class);
        } else if (!rawEventType.isAssignableFrom(eventType)) {
            throw new IncompatibleEventTypesException(String.format("Consumer %s's parameter type (%s) is not assignable from the passed event type (%s)!", listener.getClass().getName(), rawEventType.getName(), eventType.getName()));
        }
        return new SimpleSingularListener<EVENT>(eventType, listener, Objects.requireNonNullElse(phase, "default"), priority);
    }

    private Listener() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static StaticListenerBuilder staticMethods() {
        return new StaticListenerBuilder();
    }

    public static <T> ObjectListenerBuilder<T> object() {
        return new ObjectListenerBuilder();
    }

    public static <EVENT extends Event> ReflectionListenerBuilder<EVENT> reflection() {
        return new ReflectionListenerBuilder();
    }

    public static <EVENT extends Event> SimpleListenerBuilder<EVENT> simple() {
        return new SimpleListenerBuilder();
    }

    public static class ReflectionListenerBuilder<EVENT extends Event> {
        private Class<EVENT> eventType;
        private Object listener;
        private Method method;
        private String phase;
        private int priority;

        ReflectionListenerBuilder() {
        }

        public ReflectionListenerBuilder<EVENT> eventType(@Nullable Class<EVENT> eventType) {
            this.eventType = eventType;
            return this;
        }

        public ReflectionListenerBuilder<EVENT> listener(@Nullable Object listener) {
            this.listener = listener;
            return this;
        }

        public ReflectionListenerBuilder<EVENT> method(@NotNull Method method) {
            this.method = method;
            return this;
        }

        public ReflectionListenerBuilder<EVENT> phase(@Nullable String phase) {
            this.phase = phase;
            return this;
        }

        public ReflectionListenerBuilder<EVENT> priority(int priority) {
            this.priority = priority;
            return this;
        }

        public SingularListener<@NotNull EVENT> build() {
            return Listener.createReflection(this.eventType, this.listener, this.method, this.phase, this.priority);
        }

        public String toString() {
            return "Listener.ReflectionListenerBuilder(eventType=" + this.eventType + ", listener=" + this.listener + ", method=" + this.method + ", phase=" + this.phase + ", priority=" + this.priority + ")";
        }
    }

    public static class StaticListenerBuilder {
        private Class<?> listener;
        private String phase;
        private int priority;

        StaticListenerBuilder() {
        }

        public StaticListenerBuilder listener(@NotNull Class<?> listener) {
            this.listener = listener;
            return this;
        }

        public StaticListenerBuilder phase(@Nullable String phase) {
            this.phase = phase;
            return this;
        }

        public StaticListenerBuilder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public CompositeListener build() {
            return Listener.createStatic(this.listener, this.phase, this.priority);
        }

        public String toString() {
            return "Listener.StaticListenerBuilder(listener=" + this.listener + ", phase=" + this.phase + ", priority=" + this.priority + ")";
        }
    }

    public static class ObjectListenerBuilder<T> {
        private T listener;
        private String phase;
        private int priority;

        ObjectListenerBuilder() {
        }

        public ObjectListenerBuilder<T> listener(@NotNull T listener) {
            this.listener = listener;
            return this;
        }

        public ObjectListenerBuilder<T> phase(@Nullable String phase) {
            this.phase = phase;
            return this;
        }

        public ObjectListenerBuilder<T> priority(int priority) {
            this.priority = priority;
            return this;
        }

        public CompositeListener build() {
            return Listener.createObject(this.listener, this.phase, this.priority);
        }

        public String toString() {
            return "Listener.ObjectListenerBuilder(listener=" + this.listener + ", phase=" + this.phase + ", priority=" + this.priority + ")";
        }
    }

    public static class SimpleListenerBuilder<EVENT extends Event> {
        private Class<EVENT> eventType;
        private Consumer<@NotNull EVENT> listener;
        private String phase;
        private int priority;

        SimpleListenerBuilder() {
        }

        public SimpleListenerBuilder<EVENT> eventType(@Nullable Class<EVENT> eventType) {
            this.eventType = eventType;
            return this;
        }

        public SimpleListenerBuilder<EVENT> listener(@NotNull @NotNull Consumer<@NotNull EVENT> listener) {
            this.listener = listener;
            return this;
        }

        public SimpleListenerBuilder<EVENT> phase(@Nullable String phase) {
            this.phase = phase;
            return this;
        }

        public SimpleListenerBuilder<EVENT> priority(int priority) {
            this.priority = priority;
            return this;
        }

        public SingularListener<@NotNull EVENT> build() {
            return Listener.createSimple(this.eventType, this.listener, this.phase, this.priority);
        }

        public String toString() {
            return "Listener.SimpleListenerBuilder(eventType=" + this.eventType + ", listener=" + this.listener + ", phase=" + this.phase + ", priority=" + this.priority + ")";
        }
    }
}

