/*
 * Decompiled with CFR 0.152.
 */
package net.mine_diver.unsafeevents.listener;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import net.mine_diver.unsafeevents.Event;
import net.mine_diver.unsafeevents.util.UnsafeProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

final class ListenerExecutorFactory {
    @NotNull
    private static final @NotNull ConcurrentMap<@NotNull Method, @NotNull Class<? extends Consumer<? extends @NotNull Event>>> cache = new ConcurrentHashMap<Method, Class<? extends Consumer<? extends Event>>>();

    @NotNull
    private static <EVENT extends Event> @NotNull Class<? extends Consumer<@NotNull EVENT>> generateExecutor(@NotNull Method method, @NotNull Class<EVENT> eventType) {
        try {
            return MethodHandles.privateLookupIn(method.getDeclaringClass(), UnsafeProvider.IMPL_LOOKUP).defineHiddenClass(ListenerExecutorFactory.generateExecutorClass(method, method.getDeclaringClass().getName().replace('.', '/') + "$$UnsafeEvents$ListenerExecutor", eventType), true, MethodHandles.Lookup.ClassOption.NESTMATE).lookupClass().asSubclass(Consumer.class);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte @NotNull [] generateExecutorClass(@NotNull Method m, @NotNull String name, @NotNull Class<? extends Event> eventType) {
        boolean staticMethod = Modifier.isStatic(m.getModifiers());
        ClassWriter writer = new ClassWriter(3);
        writer.visit(52, 1, name, null, "java/lang/Object", new String[]{Type.getInternalName(Consumer.class)});
        if (!staticMethod) {
            writer.visitField(1, "_", "Ljava/lang/Object;", null, null).visitEnd();
        }
        MethodVisitor methodGenerator = writer.visitMethod(1, "<init>", staticMethod ? "()V" : "(Ljava/lang/Object;)V", null, null);
        methodGenerator.visitCode();
        methodGenerator.visitVarInsn(25, 0);
        methodGenerator.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        if (!staticMethod) {
            methodGenerator.visitVarInsn(25, 0);
            methodGenerator.visitVarInsn(25, 1);
            methodGenerator.visitFieldInsn(181, name, "_", "Ljava/lang/Object;");
        }
        methodGenerator.visitInsn(177);
        methodGenerator.visitMaxs(-1, -1);
        methodGenerator.visitEnd();
        methodGenerator = writer.visitMethod(1, "accept", "(Ljava/lang/Object;)V", null, null);
        methodGenerator.visitCode();
        if (!staticMethod) {
            methodGenerator.visitVarInsn(25, 0);
            methodGenerator.visitFieldInsn(180, name, "_", "Ljava/lang/Object;");
            methodGenerator.visitTypeInsn(192, Type.getInternalName(m.getDeclaringClass()));
        }
        methodGenerator.visitVarInsn(25, 1);
        methodGenerator.visitTypeInsn(192, Type.getInternalName(eventType));
        methodGenerator.visitMethodInsn(staticMethod ? 184 : 182, Type.getInternalName(m.getDeclaringClass()), m.getName(), Type.getMethodDescriptor((Method)m), m.getDeclaringClass().isInterface());
        if (m.getReturnType() != Void.TYPE) {
            methodGenerator.visitInsn(87);
        }
        methodGenerator.visitInsn(177);
        methodGenerator.visitMaxs(-1, -1);
        methodGenerator.visitEnd();
        writer.visitEnd();
        return writer.toByteArray();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    static <EVENT extends Event> @NotNull Consumer<@NotNull EVENT> create(@Nullable Object target, @NotNull Method method, @NotNull Class<EVENT> eventType) {
        @NotNull @NotNull Class executorClass = cache.computeIfAbsent(method, method1 -> ListenerExecutorFactory.generateExecutor(method1, eventType));
        try {
            return Modifier.isStatic(method.getModifiers()) ? (Consumer)executorClass.getConstructor(new Class[0]).newInstance(new Object[0]) : (Consumer)executorClass.getConstructor(Object.class).newInstance(target);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to initialize " + executorClass, e);
        }
    }

    private ListenerExecutorFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

