/*
 * Decompiled with CFR 0.152.
 */
package net.mine_diver.unsafeevents.transform;

import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Modifier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mine_diver.unsafeevents.Event;
import net.mine_diver.unsafeevents.util.Util;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public final class EventSubclassTransformer {
    private static final int FIELD_EVENTID_ACCESS = 26;
    private static final String FIELD_EVENTID_NAME = "0$UNSAFEEVENTS$EVENT_ID";
    private static final String FIELD_EVENTID_DESC = Type.INT_TYPE.getDescriptor();
    private static final String METHOD_NEXTID_NAME = "nextID";
    private static final String METHOD_NEXTID_DESC = Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0]);
    private static final int METHOD_CLINIT_ACCESS = 8;
    private static final String METHOD_CLINIT_NAME = "<clinit>";
    private static final String METHOD_CLINIT_DESC = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]);
    private static final int METHOD_GETEVENTID_ACCESS = 4;
    private static final String METHOD_GETEVENTID_NAME = "getEventID";
    private static final String METHOD_GETEVENTID_DESC = Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0]);
    private static final String CLASS_CANCELABLE_DESC = "Lnet/mine_diver/unsafeevents/event/Cancelable;";
    private static final int METHOD_ISCANCELABLE_ACCESS = 1;
    private static final String METHOD_ISCANCELABLE_NAME = "isCancelable";
    private static final String METHOD_ISCANCELABLE_DESC = Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[0]);
    private static final MethodNode METHOD_ISCANCELABLE = Util.make(new MethodNode(1, "isCancelable", METHOD_ISCANCELABLE_DESC, null, null), methodNode -> {
        methodNode.instructions.add((AbstractInsnNode)new InsnNode(4));
        methodNode.instructions.add((AbstractInsnNode)new InsnNode(172));
    });

    public static boolean handles(@NotNull String name) {
        return !name.equals("net.mine_diver.unsafeevents.Event");
    }

    public static boolean transform(@NotNull ClassLoader classLoader, @NotNull ClassNode eventNode) {
        Class<?> superClass;
        try {
            superClass = classLoader.loadClass(eventNode.superName.replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (Event.class.isAssignableFrom(superClass) && !Modifier.isAbstract(eventNode.access)) {
            boolean transformed = false;
            if (eventNode.methods.stream().noneMatch(methodNode -> (Modifier.isProtected(methodNode.access) || Modifier.isPublic(methodNode.access)) && METHOD_GETEVENTID_NAME.equals(methodNode.name) && METHOD_GETEVENTID_DESC.equals(methodNode.desc))) {
                EventSubclassTransformer.addEventIdField(eventNode);
                EventSubclassTransformer.addGetEventIdMethod(eventNode);
                transformed = true;
            }
            if (eventNode.methods.stream().noneMatch(methodNode -> Modifier.isPublic(methodNode.access) && METHOD_ISCANCELABLE_NAME.equals(methodNode.name) && METHOD_ISCANCELABLE_DESC.equals(methodNode.desc)) && eventNode.visibleAnnotations != null && eventNode.visibleAnnotations.stream().anyMatch(node -> CLASS_CANCELABLE_DESC.equals(node.desc))) {
                EventSubclassTransformer.addIsCancelable(eventNode);
                transformed = true;
            }
            return transformed;
        }
        return false;
    }

    private static void addEventIdField(ClassNode eventNode) {
        FieldNode field = new FieldNode(26, FIELD_EVENTID_NAME, FIELD_EVENTID_DESC, null, null);
        eventNode.fields.add(field);
        InsnList fieldInit = new InsnList();
        fieldInit.add((AbstractInsnNode)new MethodInsnNode(184, eventNode.name, METHOD_NEXTID_NAME, METHOD_NEXTID_DESC));
        fieldInit.add((AbstractInsnNode)new FieldInsnNode(179, eventNode.name, FIELD_EVENTID_NAME, FIELD_EVENTID_DESC));
        eventNode.methods.stream().filter((Predicate<MethodNode>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$addEventIdField$4(org.objectweb.asm.tree.MethodNode ), (Lorg/objectweb/asm/tree/MethodNode;)Z)()).findAny().orElseGet((Supplier<MethodNode>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$addEventIdField$5(org.objectweb.asm.tree.ClassNode ), ()Lorg/objectweb/asm/tree/MethodNode;)((ClassNode)eventNode)).instructions.insert(fieldInit);
    }

    private static void addGetEventIdMethod(ClassNode eventNode) {
        MethodNode method = new MethodNode(4, METHOD_GETEVENTID_NAME, METHOD_GETEVENTID_DESC, null, null);
        method.instructions.add((AbstractInsnNode)new FieldInsnNode(178, eventNode.name, FIELD_EVENTID_NAME, FIELD_EVENTID_DESC));
        method.instructions.add((AbstractInsnNode)new InsnNode(172));
        method.accept((ClassVisitor)eventNode);
    }

    private static void addIsCancelable(ClassNode eventNode) {
        METHOD_ISCANCELABLE.accept((ClassVisitor)eventNode);
    }

    private EventSubclassTransformer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static /* synthetic */ MethodNode lambda$addEventIdField$5(ClassNode eventNode) {
        MethodNode clinit = new MethodNode(8, METHOD_CLINIT_NAME, METHOD_CLINIT_DESC, null, null);
        clinit.instructions.add((AbstractInsnNode)new InsnNode(177));
        eventNode.methods.add(clinit);
        return clinit;
    }

    private static /* synthetic */ boolean lambda$addEventIdField$4(MethodNode methodNode) {
        return 8 == methodNode.access && METHOD_CLINIT_NAME.equals(methodNode.name) && METHOD_CLINIT_DESC.equals(methodNode.desc);
    }
}

