/*
 * Decompiled with CFR 0.152.
 */
package net.mine_diver.unsafeevents.util.collection;

import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class Int2ReferenceArrayMapWrapper<V> {
    @NotNull
    private final V drv;
    @NotNull
    private final @NotNull Supplier<@NotNull V @NotNull []> arrGetter;
    @NotNull
    private final @NotNull Consumer<@NotNull V @NotNull []> arrSetter;
    @NotNull
    private final @NotNull IntFunction<V @NotNull []> arrInst;

    public Int2ReferenceArrayMapWrapper(@NotNull @NotNull Supplier<@NotNull V @NotNull []> arrGetter, @NotNull @NotNull Consumer<@NotNull V @NotNull []> arrSetter, @NotNull @NotNull IntFunction<V @NotNull []> arrInst, @NotNull V defaultReturnValue, int initialCapacity) {
        this.arrGetter = arrGetter;
        this.arrSetter = arrSetter;
        this.arrInst = arrInst;
        this.drv = defaultReturnValue;
        arrSetter.accept(this.newArray(initialCapacity));
    }

    public void put(int key, @NotNull V value) {
        this.ensureArrayCapacity(key);
        this.arrGetter.get()[key] = value;
    }

    private void ensureArrayCapacity(int key) {
        if (key >= this.arrGetter.get().length) {
            this.resizeArray(key + 1);
        }
    }

    public void resizeArray(int newLength) {
        V[] newArr = this.newArray(newLength);
        System.arraycopy(this.arrGetter.get(), 0, newArr, 0, this.arrGetter.get().length);
        this.arrSetter.accept(newArr);
        if (this.arrGetter.get() != newArr) {
            throw new IllegalStateException("Array setter function didn't set the array properly, and/or array getter function returned the wrong array!");
        }
    }

    @NotNull
    private @NotNull V @NotNull [] newArray(int length) {
        Object[] arr = this.arrInst.apply(length);
        if (arr.length != length) {
            throw new IllegalStateException(String.format("Array instantiation function returned an array of incorrect size! (Expected: %d, got: %d)", length, arr.length));
        }
        Arrays.fill(arr, this.drv);
        return arr;
    }
}

